/*
 * Decompiled with CFR 0.152.
 */
package clustering;

import clustering.SeedTransformer;
import clustering.VertexScore;
import clustering.VertexScoreComparator;
import edu.uci.ics.jung.algorithms.scoring.PageRank;
import edu.uci.ics.jung.algorithms.scoring.PageRankWithPriors;
import edu.uci.ics.jung.graph.Graph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalSpectral<V, E> {
    Graph<V, E> graph;
    double alpha = 0.15;

    public Graph<V, E> getGraph() {
        return this.graph;
    }

    public void setGraph(Graph<V, E> graph) {
        this.graph = graph;
    }

    public LocalSpectral(Graph<V, E> input) {
        this.graph = input;
    }

    public void removeCutEdges(List<V> cut) {
        for (V vertex : cut) {
            Collection out_edges = this.graph.getOutEdges(vertex);
            for (Object edge : out_edges) {
                Object opposite_vertex = this.graph.getOpposite(vertex, edge);
                if (cut.contains(opposite_vertex)) continue;
                this.graph.removeEdge(edge);
            }
        }
    }

    public List<VertexScore<V>> getGlobalRank() {
        PageRank rank = new PageRank(this.graph, this.alpha);
        rank.evaluate();
        Collection vertexs = this.graph.getVertices();
        Iterator vertexsIterator = vertexs.iterator();
        ArrayList<VertexScore<V>> vertexsScore = new ArrayList<VertexScore<V>>();
        while (vertexsIterator.hasNext()) {
            Object vertex = vertexsIterator.next();
            Double score = (Double)rank.getVertexScore(vertex);
            VertexScore vertexscore = new VertexScore(vertex, score);
            vertexsScore.add(vertexscore);
        }
        Collections.sort(vertexsScore, new VertexScoreComparator());
        return vertexsScore;
    }

    public List<V> clusterPageRankPriors(V seed, double min_volume) {
        PageRank rank;
        if (seed != null) {
            SeedTransformer<V> transf = new SeedTransformer<V>(seed);
            rank = new PageRankWithPriors(this.graph, transf, this.alpha);
        } else {
            rank = new PageRank(this.graph, this.alpha);
        }
        rank.evaluate();
        Collection vertexs = this.graph.getVertices();
        Iterator vertexsIterator = vertexs.iterator();
        ArrayList vertexsScore = new ArrayList();
        while (vertexsIterator.hasNext()) {
            Object vertex = vertexsIterator.next();
            Double score = (Double)rank.getVertexScore(vertex);
            int degree = this.graph.getIncidentEdges(vertex).size();
            VertexScore vertexscore = new VertexScore(vertex, score / (double)degree);
            vertexsScore.add(vertexscore);
        }
        Collections.sort(vertexsScore, new VertexScoreComparator());
        System.out.println("\n\nClustering with prior seed: " + seed.toString());
        int volume_graph = 2 * this.graph.getEdgeCount();
        double max_volume = volume_graph / 3 * 2;
        double min_conductance_subset = 100.0;
        int min_conductance_index = -1;
        int subsets_count = vertexsScore.size();
        for (int i = 0; i < subsets_count; ++i) {
            int volume_subset = 0;
            ArrayList subset = new ArrayList();
            for (int j = 0; j < i; ++j) {
                subset.add(((VertexScore)vertexsScore.get(j)).getVertex());
            }
            int edge_boundary = 0;
            for (int j = 0; j < i; ++j) {
                volume_subset += this.graph.getIncidentEdges(((VertexScore)vertexsScore.get(j)).getVertex()).size();
                for (Object out_edge : this.graph.getOutEdges(((VertexScore)vertexsScore.get(j)).getVertex())) {
                    Object opposite = this.graph.getOpposite(((VertexScore)vertexsScore.get(j)).getVertex(), out_edge);
                    if (subset.contains(opposite)) continue;
                    ++edge_boundary;
                }
            }
            if (volume_subset <= 0) continue;
            double minvolume = volume_subset;
            if (volume_subset > volume_graph - volume_subset) {
                minvolume = volume_graph - volume_subset;
            }
            double conductance = (double)edge_boundary / minvolume;
            if (!((double)volume_subset > min_volume) || !((double)volume_subset < max_volume) || !(conductance < min_conductance_subset)) continue;
            min_conductance_subset = conductance;
            min_conductance_index = i;
        }
        System.out.println("MIN CONDUCTANCE: " + min_conductance_subset);
        System.out.println("CLUSTER: ");
        ArrayList cluster = new ArrayList();
        for (int i = 0; i < min_conductance_index; ++i) {
            cluster.add(((VertexScore)vertexsScore.get(i)).getVertex());
        }
        String node_list = "";
        for (Object node : cluster) {
            node_list = node_list + node.toString() + ",";
        }
        System.out.println(node_list);
        return cluster;
    }
}

