package weka.clusterers;


import weka.clusterers.forMetisMQI.GraphAlgorithms;
import weka.clusterers.forMetisMQI.graph.UndirectedGraph;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Capabilities.Capability;

public class SimpleClusterer extends AbstractClusterer {

	private int numberOfClusters = 0;

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	@Override
	public void buildClusterer(Instances data) throws Exception {
		getCapabilities().testWithFail(data);
		
		UndirectedGraph g = new UndirectedGraph();
		g.loadFromInstance(data);
		GraphAlgorithms ga = new GraphAlgorithms();
		ga.METIS(g);
		numberOfClusters = 1;
	}

	@Override
	public int clusterInstance(Instance instance) throws Exception {
		return 0;
	}

	@Override
	public double[] distributionForInstance(Instance instance) 
	throws Exception {
		double[] d = new double[numberOfClusters()];
		d[clusterInstance(instance)] = 1.0;
		return d;
	}

	@Override
	public Capabilities getCapabilities() {
		Capabilities result = super.getCapabilities();
		result.enable(Capability.NUMERIC_ATTRIBUTES);
		result.enable(Capability.NO_CLASS);
		return result;
	}

	@Override
	public int numberOfClusters() throws Exception {
		return numberOfClusters;
	}

	/**
	 * Main method for executing this clusterer.
	 * 
	 * @param args
	 *            the options, use "-h" to display options
	 */
	public static void main(String[] args) {
		AbstractClusterer.runClusterer(new SimpleClusterer(), args);
	}

}
