/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.jai;

import edu.uci.ics.jung.visualization.transform.MutableAffineTransformer;
import edu.uci.ics.jung.visualization.transform.MutableTransformer;
import edu.uci.ics.jung.visualization.transform.MutableTransformerDecorator;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import javax.media.jai.PerspectiveTransform;

public class PerspectiveTransformer
extends MutableTransformerDecorator
implements MutableTransformer {
    protected PerspectiveTransform perspectiveTransform;

    public PerspectiveTransformer(PerspectiveTransform perspectiveTransform) {
        this(perspectiveTransform, (MutableTransformer)new MutableAffineTransformer());
    }

    public PerspectiveTransformer(PerspectiveTransform perspectiveTransform, MutableTransformer delegate) {
        super(delegate);
        this.perspectiveTransform = perspectiveTransform;
    }

    public void setToIdentity() {
        this.perspectiveTransform.setToIdentity();
    }

    public PerspectiveTransform createInverse() {
        try {
            return this.perspectiveTransform.createInverse();
        }
        catch (NoninvertibleTransformException e) {
            e.printStackTrace();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return null;
    }

    public Point2D transform(Point2D graphPoint) {
        if (graphPoint == null) {
            return null;
        }
        Point2D p2 = super.transform(graphPoint);
        return this.perspectiveTransform.transform(p2, null);
    }

    public Point2D inverseTransform(Point2D viewPoint) {
        Point2D p2 = this.createInverse().transform(viewPoint, null);
        return super.inverseTransform(p2);
    }

    public Point2D perspectiveTransform(Point2D graphPoint) {
        if (graphPoint == null) {
            return null;
        }
        return this.perspectiveTransform.transform(graphPoint, null);
    }

    public Point2D inversePerspectiveTransform(Point2D viewPoint) {
        return this.createInverse().transform(viewPoint, null);
    }

    public PerspectiveTransform getPerspectiveTransform() {
        return this.perspectiveTransform;
    }

    public void setPerspectiveTransform(PerspectiveTransform perspectiveTransform) {
        this.perspectiveTransform = perspectiveTransform;
    }
}

