/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.renderers;

import edu.uci.ics.jung.visualization.renderers.EdgeLabelRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Rectangle;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultEdgeLabelRenderer
extends JLabel
implements EdgeLabelRenderer,
Serializable {
    protected static Border noFocusBorder = new EmptyBorder(0, 0, 0, 0);
    protected Color pickedEdgeLabelColor = Color.black;
    protected boolean rotateEdgeLabels;

    public DefaultEdgeLabelRenderer(Color pickedEdgeLabelColor) {
        this(pickedEdgeLabelColor, true);
    }

    public DefaultEdgeLabelRenderer(Color pickedEdgeLabelColor, boolean rotateEdgeLabels) {
        this.pickedEdgeLabelColor = pickedEdgeLabelColor;
        this.rotateEdgeLabels = rotateEdgeLabels;
        this.setOpaque(true);
        this.setBorder(noFocusBorder);
    }

    @Override
    public boolean isRotateEdgeLabels() {
        return this.rotateEdgeLabels;
    }

    @Override
    public void setRotateEdgeLabels(boolean rotateEdgeLabels) {
        this.rotateEdgeLabels = rotateEdgeLabels;
    }

    @Override
    public void setForeground(Color c) {
        super.setForeground(c);
    }

    @Override
    public void setBackground(Color c) {
        super.setBackground(c);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setForeground(null);
        this.setBackground(null);
    }

    public <E> Component getEdgeLabelRendererComponent(JComponent vv, Object value, Font font, boolean isSelected, E edge) {
        super.setForeground(vv.getForeground());
        if (isSelected) {
            this.setForeground(this.pickedEdgeLabelColor);
        }
        super.setBackground(vv.getBackground());
        if (font != null) {
            this.setFont(font);
        } else {
            this.setFont(vv.getFont());
        }
        this.setIcon(null);
        this.setBorder(noFocusBorder);
        this.setValue(value);
        return this;
    }

    @Override
    public boolean isOpaque() {
        Color back = this.getBackground();
        Container p = this.getParent();
        if (p != null) {
            p = p.getParent();
        }
        boolean colorMatch = back != null && p != null && back.equals(p.getBackground()) && p.isOpaque();
        return !colorMatch && super.isOpaque();
    }

    @Override
    public void validate() {
    }

    @Override
    public void revalidate() {
    }

    @Override
    public void repaint(long tm, int x, int y, int width, int height) {
    }

    @Override
    public void repaint(Rectangle r) {
    }

    @Override
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (propertyName == "text") {
            super.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    @Override
    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }

    protected void setValue(Object value) {
        this.setText(value == null ? "" : value.toString());
    }
}

