/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package jung;

import clustering.LocalSpectral;
import clustering.VertexScore;
import data.GraphBuilder;
import edu.uci.ics.jung.algorithms.scoring.PageRank;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.SparseGraph;
import java.awt.Paint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import view.VertexPaintTransformer;
import view.Viewer;

public class Main {

    public static void main(String[] args) {
       GraphBuilder builder = new GraphBuilder();
       builder.buildGraphFromARFF("/home/luke/Desktop/reteSemplice.txt", 6000);
       Graph<String, Integer> graph = builder.getGraph();
       Viewer viewGraph = new Viewer(graph);
       viewGraph.viewGraph(null);
       LocalSpectral<String,Integer> clusterer = new LocalSpectral(graph);
       List<VertexScore<String>> global_ranking = clusterer.getGlobalRank();
       System.out.println("GLOBAL RANKING");
       for(VertexScore<String> v : global_ranking)
           System.out.println("VERTEX: "+v + " RANK "+v.getScore());
       for(VertexScore<String> v : global_ranking){
           Long stoptime = 5000L; 
           try {
                Thread.sleep(stoptime);
            } catch (InterruptedException e) {}
           List<String> cut = clusterer.clusterPageRankPriors(v.getVertex(),6);
           viewGraph.viewGraph(cut);
       }

    }


}
