/*
 * Decompiled with CFR 0.152.
 */
package clustering;

import clustering.SeedTransformer;
import clustering.VertexScore;
import clustering.VertexScoreComparator;
import edu.uci.ics.jung.algorithms.scoring.PageRank;
import edu.uci.ics.jung.algorithms.scoring.PageRankWithPriors;
import edu.uci.ics.jung.graph.Graph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalSpectral<V, E> {
    Graph<V, E> graph;
    double alpha = 0.15;

    public Graph<V, E> getGraph() {
        return this.graph;
    }

    public void setGraph(Graph<V, E> graph) {
        this.graph = graph;
    }

    public LocalSpectral(Graph<V, E> input) {
        this.graph = input;
    }

    public Graph<V, E> clusterPageRankPriors(V seed, double min_volume) {
        PageRank rank;
        if (seed != null) {
            SeedTransformer<V> transf = new SeedTransformer<V>(seed);
            rank = new PageRankWithPriors(this.graph, transf, this.alpha);
        } else {
            rank = new PageRank(this.graph, this.alpha);
        }
        rank.evaluate();
        Collection vertexs = this.graph.getVertices();
        Iterator vertexsIterator = vertexs.iterator();
        ArrayList vertexsScore = new ArrayList();
        while (vertexsIterator.hasNext()) {
            Object vertex = vertexsIterator.next();
            Double score = (Double)rank.getVertexScore(vertex);
            int degree = this.graph.getIncidentEdges(vertex).size();
            VertexScore vertexScore = new VertexScore(vertex, score / (double)degree);
            vertexsScore.add(vertexScore);
        }
        Collections.sort(vertexsScore, new VertexScoreComparator());
        double sum = 0.0;
        for (VertexScore vertexScore : vertexsScore) {
            System.out.println(vertexScore.getVertex().toString() + " " + vertexScore.getScore());
            sum += vertexScore.getScore();
        }
        System.out.println("SUM SCORES: " + sum);
        int volume_graph = 2 * this.graph.getEdgeCount();
        System.out.println("GRAPH VOLUME: " + volume_graph);
        double d = volume_graph / 3 * 2;
        double min_conductance_subset = 100.0;
        int min_conductance_index = -1;
        int subsets_count = vertexsScore.size();
        for (int i = 0; i < subsets_count; ++i) {
            System.out.println("i=" + i);
            int volume_subset = 0;
            ArrayList subset = new ArrayList();
            for (int j = 0; j < i; ++j) {
                subset.add(((VertexScore)vertexsScore.get(j)).getVertex());
            }
            int edge_boundary = 0;
            for (int j = 0; j < i; ++j) {
                volume_subset += this.graph.getIncidentEdges(((VertexScore)vertexsScore.get(j)).getVertex()).size();
                for (Object out_edge : this.graph.getOutEdges(((VertexScore)vertexsScore.get(j)).getVertex())) {
                    Object opposite = this.graph.getOpposite(((VertexScore)vertexsScore.get(j)).getVertex(), out_edge);
                    if (subset.contains(opposite)) continue;
                    ++edge_boundary;
                }
            }
            if (volume_subset <= 0) continue;
            double minvolume = volume_subset;
            if (volume_subset > volume_graph - volume_subset) {
                minvolume = volume_graph - volume_subset;
            }
            double conductance = (double)edge_boundary / minvolume;
            if ((double)volume_subset > min_volume && (double)volume_subset < d && conductance < min_conductance_subset) {
                min_conductance_subset = conductance;
                min_conductance_index = i;
            }
            System.out.println("CONDUCTANCE: " + conductance + " minvolume: " + minvolume + " edge_boundary: " + edge_boundary);
        }
        System.out.println("MIN CONDUCTANCE: " + min_conductance_subset + " INDEX " + min_conductance_index);
        ArrayList cluster = new ArrayList();
        for (int i = 0; i < min_conductance_index; ++i) {
            cluster.add(((VertexScore)vertexsScore.get(i)).getVertex());
        }
        Collection aux = this.graph.getVertices();
        ArrayList vertices_to_remove = new ArrayList();
        for (Object vertex : aux) {
            vertices_to_remove.add(vertex);
        }
        for (Object vertex : cluster) {
            vertices_to_remove.remove(vertex);
        }
        for (Object vertex : vertices_to_remove) {
            this.graph.removeVertex(vertex);
        }
        return this.graph;
    }
}

