/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.CompileState;
import javax.media.j3d.GroupRetained;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.Node;
import javax.media.j3d.NodeRetained;
import javax.media.j3d.OrderedBin;
import javax.media.j3d.OrderedPath;
import javax.media.j3d.SetLiveState;
import javax.media.j3d.VirtualUniverse;

class OrderedGroupRetained
extends GroupRetained {
    int[] orderedChildIdTable;
    private int orderedChildIdCount = 0;
    private ArrayList orderedChildIdFreeList = new ArrayList();
    OrderedBin[] orderedBin = new OrderedBin[0];
    Integer newChildId;
    int childCount = 0;
    ArrayList childrenOrderedPaths = new ArrayList(1);
    int[] userChildIndexOrder = null;
    int[] childIndexOrder = null;

    OrderedGroupRetained() {
        this.nodeType = 20;
    }

    void setChildIndexOrder(int[] nArray) {
        if (nArray != null) {
            if (this.userChildIndexOrder == null || this.userChildIndexOrder.length != nArray.length) {
                this.userChildIndexOrder = new int[nArray.length];
            }
            System.arraycopy(nArray, 0, this.userChildIndexOrder, 0, this.userChildIndexOrder.length);
        } else {
            this.userChildIndexOrder = null;
        }
        if (this.source.isLive()) {
            int[] nArray2 = new int[nArray.length];
            System.arraycopy(nArray, 0, nArray2, 0, nArray2.length);
            J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
            j3dMessage.threads = 128;
            j3dMessage.type = 59;
            j3dMessage.universe = this.universe;
            j3dMessage.args[3] = this;
            j3dMessage.args[4] = nArray2;
            VirtualUniverse.mc.processMessage(j3dMessage);
        }
    }

    int[] getChildIndexOrder() {
        if (this.userChildIndexOrder == null) {
            return null;
        }
        int[] nArray = new int[this.userChildIndexOrder.length];
        System.arraycopy(this.userChildIndexOrder, 0, nArray, 0, this.userChildIndexOrder.length);
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Integer getOrderedChildId() {
        Integer n;
        ArrayList arrayList = this.orderedChildIdFreeList;
        synchronized (arrayList) {
            if (this.orderedChildIdFreeList.size() == 0) {
                n = new Integer(this.orderedChildIdCount);
                ++this.orderedChildIdCount;
            } else {
                n = (Integer)this.orderedChildIdFreeList.remove(0);
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void freeOrderedChildId(int n) {
        ArrayList arrayList = this.orderedChildIdFreeList;
        synchronized (arrayList) {
            this.orderedChildIdFreeList.add(new Integer(n));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getOrderedChildCount() {
        int n;
        ArrayList arrayList = this.orderedChildIdFreeList;
        synchronized (arrayList) {
            n = this.orderedChildIdCount;
        }
        return n;
    }

    void addChild(Node node) {
        if (this.userChildIndexOrder != null) {
            this.doAddChildIndexEntry();
        }
        super.addChild(node);
    }

    void addChild(Node node, int[] nArray) {
        if (nArray != null) {
            this.userChildIndexOrder = new int[nArray.length];
            System.arraycopy(nArray, 0, this.userChildIndexOrder, 0, this.userChildIndexOrder.length);
        } else {
            this.userChildIndexOrder = null;
        }
        super.addChild(node);
    }

    void moveTo(BranchGroup branchGroup) {
        if (this.userChildIndexOrder != null) {
            this.doAddChildIndexEntry();
        }
        super.moveTo(branchGroup);
    }

    void doRemoveChildIndexEntry(int n) {
        int[] nArray = new int[this.userChildIndexOrder.length - 1];
        int n2 = 0;
        int n3 = 0;
        while (n2 < this.userChildIndexOrder.length) {
            if (this.userChildIndexOrder[n2] > n) {
                nArray[n3] = this.userChildIndexOrder[n2] - 1;
                ++n3;
            } else if (this.userChildIndexOrder[n2] < n) {
                nArray[n3] = this.userChildIndexOrder[n2];
                ++n3;
            }
            ++n2;
        }
        this.userChildIndexOrder = nArray;
    }

    void doAddChildIndexEntry() {
        int[] nArray = new int[this.userChildIndexOrder.length + 1];
        System.arraycopy(this.userChildIndexOrder, 0, nArray, 0, this.userChildIndexOrder.length);
        nArray[this.userChildIndexOrder.length] = this.userChildIndexOrder.length;
        this.userChildIndexOrder = nArray;
    }

    void compile(CompileState compileState) {
        super.compile(compileState);
        this.mergeFlag = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setOrderedBin(OrderedBin orderedBin, int n) {
        OrderedBin[] orderedBinArray = this.orderedBin;
        synchronized (orderedBinArray) {
            this.orderedBin[n] = orderedBin;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OrderedBin getOrderedBin(int n) {
        OrderedBin[] orderedBinArray = this.orderedBin;
        synchronized (orderedBinArray) {
            if (n >= this.orderedBin.length) {
                OrderedBin[] orderedBinArray2 = new OrderedBin[n + 1];
                int n2 = 0;
                while (n2 < this.orderedBin.length) {
                    orderedBinArray2[n2] = this.orderedBin[n2];
                    ++n2;
                }
                orderedBinArray2[n] = null;
                this.orderedBin = orderedBinArray2;
            }
        }
        return this.orderedBin[n];
    }

    void updateChildIdTableInserted(int n, int n2) {
        int n3;
        int n4 = 0;
        if (this.orderedChildIdTable != null) {
            n4 = this.orderedChildIdTable.length;
            n3 = 0;
            while (n3 < n4) {
                if (this.orderedChildIdTable[n3] != -1 && this.orderedChildIdTable[n3] >= n) {
                    int n5 = n3;
                    this.orderedChildIdTable[n5] = this.orderedChildIdTable[n5] + 1;
                }
                ++n3;
            }
        }
        if (n2 >= n4) {
            int[] nArray = new int[n2 + 1];
            if (n4 > 0) {
                System.arraycopy(this.orderedChildIdTable, 0, nArray, 0, this.orderedChildIdTable.length);
            } else {
                n3 = 0;
                while (n3 < nArray.length) {
                    nArray[n3] = -1;
                    ++n3;
                }
            }
            this.orderedChildIdTable = nArray;
        }
        this.orderedChildIdTable[n2] = n;
    }

    void updateChildIdTableRemoved(int n) {
        if (this.orderedChildIdTable == null) {
            return;
        }
        int n2 = 0;
        while (n2 < this.orderedChildIdTable.length) {
            if (this.orderedChildIdTable[n2] != -1) {
                if (this.orderedChildIdTable[n2] > n) {
                    int n3 = n2;
                    this.orderedChildIdTable[n3] = this.orderedChildIdTable[n3] - 1;
                } else if (this.orderedChildIdTable[n2] == n) {
                    this.orderedChildIdTable[n2] = -1;
                    this.freeOrderedChildId(n2);
                }
            }
            ++n2;
        }
    }

    void setAuxData(SetLiveState setLiveState, int n, int n2) {
        OrderedPath orderedPath = (OrderedPath)setLiveState.orderedPaths.get(n2);
        int n3 = 0;
        while (n3 < this.children.size()) {
            NodeRetained nodeRetained = (NodeRetained)this.children.get(n3);
            if (this.refCount == setLiveState.refCount) {
                nodeRetained.orderedId = this.getOrderedChildId();
            }
            OrderedPath orderedPath2 = orderedPath.clonePath();
            orderedPath2.addElementToPath(this, nodeRetained.orderedId);
            ArrayList arrayList = (ArrayList)this.childrenOrderedPaths.get(n3);
            arrayList.add(n2, orderedPath2);
            ++n3;
        }
    }

    void setLive(SetLiveState setLiveState) {
        super.setLive(setLiveState);
        setLiveState.orderedPaths = this.orderedPaths;
        if (this.userChildIndexOrder != null && this.refCount == 1) {
            int[] nArray = new int[this.userChildIndexOrder.length];
            System.arraycopy(this.userChildIndexOrder, 0, nArray, 0, this.userChildIndexOrder.length);
            this.childIndexOrder = nArray;
        }
    }

    void clearLive(SetLiveState setLiveState) {
        super.clearLive(setLiveState);
        if (this.refCount == 0) {
            setLiveState.notifyThreads |= 0x1000;
            setLiveState.nodeList.add(this);
            setLiveState.ogCIOList.add(this);
            setLiveState.ogCIOTableList.add(null);
            this.userChildIndexOrder = null;
        }
        setLiveState.orderedPaths = this.orderedPaths;
    }

    void setNodeData(SetLiveState setLiveState) {
        super.setNodeData(setLiveState);
        if (!this.inSharedGroup) {
            this.setAuxData(setLiveState, 0, 0);
        } else {
            int n = 0;
            while (n < setLiveState.keys.length) {
                int n2 = setLiveState.keys[n].equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
                if (n2 >= 0) {
                    this.setAuxData(setLiveState, n, n2);
                } else {
                    System.out.println("Can't Find matching hashKey in setNodeData.");
                    System.out.println("We're in TROUBLE!!!");
                }
                ++n;
            }
        }
    }

    void removeNodeData(SetLiveState setLiveState) {
        if (this.inSharedGroup && setLiveState.keys.length != this.localToVworld.length) {
            int n = setLiveState.keys.length - 1;
            while (n >= 0) {
                int n2 = setLiveState.keys[n].equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
                if (n2 >= 0) {
                    int n3 = 0;
                    while (n3 < this.children.size()) {
                        ArrayList arrayList = (ArrayList)this.childrenOrderedPaths.get(n3);
                        arrayList.remove(n2);
                        ++n3;
                    }
                }
                --n;
            }
        }
        super.removeNodeData(setLiveState);
    }

    void clearDerivedDataStructures() {
        int n = 0;
        while (n < this.orderedBin.length) {
            if (this.orderedBin[n] != null) {
                this.orderedBin[n].source = null;
                this.orderedBin[n] = null;
            }
            ++n;
        }
        if (this.orderedChildIdTable != null) {
            n = 0;
            while (n < this.orderedChildIdTable.length) {
                if (this.orderedChildIdTable[n] != -1) {
                    this.orderedChildIdTable[n] = -1;
                    this.freeOrderedChildId(n);
                }
                ++n;
            }
            this.orderedChildIdTable = null;
        }
    }

    void incrChildCount() {
        ++this.childCount;
    }

    void decrChildCount() {
        --this.childCount;
    }

    void printTable(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            System.out.print(" " + nArray[n]);
            ++n;
        }
        System.out.println("");
    }

    void insertChildrenData(int n) {
        this.childrenOrderedPaths.add(n, new ArrayList(1));
    }

    void appendChildrenData() {
        this.childrenOrderedPaths.add(new ArrayList(1));
    }

    void doRemoveChild(int n, J3dMessage[] j3dMessageArray, int n2) {
        if (this.userChildIndexOrder != null) {
            this.doRemoveChildIndexEntry(n);
        }
        super.doRemoveChild(n, j3dMessageArray, n2);
    }

    void removeChildrenData(int n) {
        this.childrenOrderedPaths.remove(n);
    }

    void childDoSetLive(NodeRetained nodeRetained, int n, SetLiveState setLiveState) {
        if (this.refCount == setLiveState.refCount) {
            setLiveState.ogList.add(this);
            setLiveState.ogChildIdList.add(new Integer(n));
            setLiveState.ogOrderedIdList.add(nodeRetained.orderedId);
        }
        setLiveState.orderedPaths = (ArrayList)this.childrenOrderedPaths.get(n);
        if (nodeRetained != null) {
            nodeRetained.setLive(setLiveState);
        }
    }

    void childCheckSetLive(NodeRetained nodeRetained, int n, SetLiveState setLiveState, NodeRetained nodeRetained2) {
        ArrayList arrayList;
        if (nodeRetained2 != null) {
            int n2 = this.children.indexOf(nodeRetained2);
            arrayList = (ArrayList)this.childrenOrderedPaths.get(n2);
        } else {
            nodeRetained.orderedId = this.getOrderedChildId();
            setLiveState.ogList.add(this);
            setLiveState.ogChildIdList.add(new Integer(n));
            setLiveState.ogOrderedIdList.add(nodeRetained.orderedId);
            if (this.userChildIndexOrder != null) {
                setLiveState.ogCIOList.add(this);
                int[] nArray = new int[this.userChildIndexOrder.length];
                System.arraycopy(this.userChildIndexOrder, 0, nArray, 0, this.userChildIndexOrder.length);
                setLiveState.ogCIOTableList.add(nArray);
            }
            arrayList = (ArrayList)this.childrenOrderedPaths.get(n);
            int n3 = 0;
            while (n3 < this.orderedPaths.size()) {
                OrderedPath orderedPath = ((OrderedPath)this.orderedPaths.get(n3)).clonePath();
                orderedPath.addElementToPath(this, nodeRetained.orderedId);
                arrayList.add(orderedPath);
                ++n3;
            }
        }
        setLiveState.orderedPaths = arrayList;
        nodeRetained.setLive(setLiveState);
    }
}

