/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections15.iterators;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumerationIterator<E>
implements Iterator<E> {
    private Collection<E> collection;
    private Enumeration<E> enumeration;
    private E last;

    public EnumerationIterator() {
        this(null, null);
    }

    public EnumerationIterator(Enumeration<E> enumeration) {
        this(enumeration, null);
    }

    public EnumerationIterator(Enumeration<E> enumeration, Collection<E> collection) {
        this.enumeration = enumeration;
        this.collection = collection;
        this.last = null;
    }

    @Override
    public boolean hasNext() {
        return this.enumeration.hasMoreElements();
    }

    @Override
    public E next() {
        this.last = this.enumeration.nextElement();
        return this.last;
    }

    @Override
    public void remove() {
        if (this.collection != null) {
            if (this.last == null) {
                throw new IllegalStateException("next() must have been called for remove() to function");
            }
        } else {
            throw new UnsupportedOperationException("No Collection associated with this Iterator");
        }
        this.collection.remove(this.last);
    }

    public Enumeration<E> getEnumeration() {
        return this.enumeration;
    }

    public void setEnumeration(Enumeration<E> enumeration) {
        this.enumeration = enumeration;
    }
}

