/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.samples;

import edu.uci.ics.jung.algorithms.layout.FRLayout;
import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.algorithms.layout.util.RandomLocationTransformer;
import edu.uci.ics.jung.graph.DirectedSparseGraph;
import edu.uci.ics.jung.graph.util.EdgeType;
import edu.uci.ics.jung.visualization.FourPassImageShaper;
import edu.uci.ics.jung.visualization.GraphZoomScrollPane;
import edu.uci.ics.jung.visualization.Layer;
import edu.uci.ics.jung.visualization.LayeredIcon;
import edu.uci.ics.jung.visualization.RenderContext;
import edu.uci.ics.jung.visualization.VisualizationServer;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.CrossoverScalingControl;
import edu.uci.ics.jung.visualization.control.DefaultModalGraphMouse;
import edu.uci.ics.jung.visualization.control.ScalingControl;
import edu.uci.ics.jung.visualization.decorators.DefaultVertexIconTransformer;
import edu.uci.ics.jung.visualization.decorators.EllipseVertexShapeTransformer;
import edu.uci.ics.jung.visualization.decorators.PickableEdgePaintTransformer;
import edu.uci.ics.jung.visualization.decorators.PickableVertexPaintTransformer;
import edu.uci.ics.jung.visualization.decorators.ToStringLabeller;
import edu.uci.ics.jung.visualization.decorators.VertexIconShapeTransformer;
import edu.uci.ics.jung.visualization.picking.PickedInfo;
import edu.uci.ics.jung.visualization.picking.PickedState;
import edu.uci.ics.jung.visualization.renderers.BasicVertexRenderer;
import edu.uci.ics.jung.visualization.renderers.Checkmark;
import edu.uci.ics.jung.visualization.renderers.DefaultEdgeLabelRenderer;
import edu.uci.ics.jung.visualization.renderers.DefaultVertexLabelRenderer;
import edu.uci.ics.jung.visualization.renderers.EdgeLabelRenderer;
import edu.uci.ics.jung.visualization.renderers.VertexLabelRenderer;
import edu.uci.ics.jung.visualization.transform.shape.GraphicsDecorator;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.apache.commons.collections15.Transformer;

public class VertexImageShaperDemo
extends JApplet {
    private static final long serialVersionUID = -4332663871914930864L;
    private static final int VERTEX_COUNT = 11;
    DirectedSparseGraph<Number, Number> graph;
    VisualizationViewer<Number, Number> vv;
    String[] iconNames = new String[]{"apple", "os", "x", "linux", "inputdevices", "wireless", "graphics3", "gamespcgames", "humor", "music", "privacy"};

    public VertexImageShaperDemo() {
        this.graph = new DirectedSparseGraph();
        this.createGraph(11);
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        for (int i = 0; i < 11; ++i) {
            map.put(i, this.iconNames[i % this.iconNames.length]);
        }
        HashMap<Integer, LayeredIcon> iconMap = new HashMap<Integer, LayeredIcon>();
        for (int i = 0; i < 11; ++i) {
            String name = "/images/topic" + this.iconNames[i] + ".gif";
            try {
                LayeredIcon icon = new LayeredIcon(new ImageIcon(VertexImageShaperDemo.class.getResource(name)).getImage());
                iconMap.put(i, icon);
                continue;
            }
            catch (Exception ex) {
                System.err.println("You need slashdoticons.jar in your classpath to see the image " + name);
            }
        }
        FRLayout layout = new FRLayout(this.graph);
        layout.setMaxIterations(100);
        layout.setInitializer((Transformer)new RandomLocationTransformer(new Dimension(400, 400), 0L));
        this.vv = new VisualizationViewer((Layout)layout, new Dimension(400, 400));
        this.vv.getRenderer().setVertexRenderer(new DemoRenderer());
        PickableVertexPaintTransformer vpf = new PickableVertexPaintTransformer((PickedInfo)this.vv.getPickedVertexState(), (Paint)Color.white, (Paint)Color.yellow);
        this.vv.getRenderContext().setVertexFillPaintTransformer((Transformer)vpf);
        this.vv.getRenderContext().setEdgeDrawPaintTransformer((Transformer)new PickableEdgePaintTransformer((PickedInfo)this.vv.getPickedEdgeState(), (Paint)Color.black, (Paint)Color.cyan));
        this.vv.setBackground(Color.white);
        VertexStringerImpl vertexStringerImpl = new VertexStringerImpl(map);
        this.vv.getRenderContext().setVertexLabelTransformer(vertexStringerImpl);
        this.vv.getRenderContext().setVertexLabelRenderer((VertexLabelRenderer)new DefaultVertexLabelRenderer(Color.cyan));
        this.vv.getRenderContext().setEdgeLabelRenderer((EdgeLabelRenderer)new DefaultEdgeLabelRenderer(Color.cyan));
        final DemoVertexIconShapeTransformer vertexIconShapeTransformer = new DemoVertexIconShapeTransformer(new EllipseVertexShapeTransformer());
        final DemoVertexIconTransformer vertexIconTransformer = new DemoVertexIconTransformer();
        vertexIconShapeTransformer.setIconMap(iconMap);
        vertexIconTransformer.setIconMap(iconMap);
        this.vv.getRenderContext().setVertexShapeTransformer(vertexIconShapeTransformer);
        this.vv.getRenderContext().setVertexIconTransformer(vertexIconTransformer);
        PickedState ps = this.vv.getPickedVertexState();
        ps.addItemListener(new PickWithIconListener(vertexIconTransformer));
        this.vv.addPostRenderPaintable(new VisualizationServer.Paintable(){
            int x;
            int y;
            Font font;
            FontMetrics metrics;
            int swidth;
            int sheight;
            String str = "Thank You, slashdot.org, for the images!";

            public void paint(Graphics g) {
                Dimension d = VertexImageShaperDemo.this.vv.getSize();
                if (this.font == null) {
                    this.font = new Font(g.getFont().getName(), 1, 20);
                    this.metrics = g.getFontMetrics(this.font);
                    this.swidth = this.metrics.stringWidth(this.str);
                    this.sheight = this.metrics.getMaxAscent() + this.metrics.getMaxDescent();
                    this.x = (d.width - this.swidth) / 2;
                    this.y = (int)((double)d.height - (double)this.sheight * 1.5);
                }
                g.setFont(this.font);
                Color oldColor = g.getColor();
                g.setColor(Color.lightGray);
                g.drawString(this.str, this.x, this.y);
                g.setColor(oldColor);
            }

            public boolean useTransform() {
                return false;
            }
        });
        this.vv.setVertexToolTipTransformer((Transformer)new ToStringLabeller());
        Container content = this.getContentPane();
        GraphZoomScrollPane panel = new GraphZoomScrollPane(this.vv);
        content.add((Component)panel);
        DefaultModalGraphMouse graphMouse = new DefaultModalGraphMouse();
        this.vv.setGraphMouse((VisualizationViewer.GraphMouse)graphMouse);
        this.vv.addKeyListener(graphMouse.getModeKeyListener());
        CrossoverScalingControl scaler = new CrossoverScalingControl();
        JButton plus = new JButton("+");
        plus.addActionListener(new ActionListener((ScalingControl)scaler){
            final /* synthetic */ ScalingControl val$scaler;
            {
                this.val$scaler = scalingControl;
            }

            public void actionPerformed(ActionEvent e) {
                this.val$scaler.scale(VertexImageShaperDemo.this.vv, 1.1f, VertexImageShaperDemo.this.vv.getCenter());
            }
        });
        JButton minus = new JButton("-");
        minus.addActionListener(new ActionListener((ScalingControl)scaler){
            final /* synthetic */ ScalingControl val$scaler;
            {
                this.val$scaler = scalingControl;
            }

            public void actionPerformed(ActionEvent e) {
                this.val$scaler.scale(VertexImageShaperDemo.this.vv, 0.9090909f, VertexImageShaperDemo.this.vv.getCenter());
            }
        });
        JCheckBox shape = new JCheckBox("Shape");
        shape.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                vertexIconShapeTransformer.setShapeImages(e.getStateChange() == 1);
                VertexImageShaperDemo.this.vv.repaint();
            }
        });
        shape.setSelected(true);
        JCheckBox fill = new JCheckBox("Fill");
        fill.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                vertexIconTransformer.setFillImages(e.getStateChange() == 1);
                VertexImageShaperDemo.this.vv.repaint();
            }
        });
        fill.setSelected(true);
        JCheckBox drawOutlines = new JCheckBox("Outline");
        drawOutlines.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                vertexIconTransformer.setOutlineImages(e.getStateChange() == 1);
                VertexImageShaperDemo.this.vv.repaint();
            }
        });
        JComboBox modeBox = graphMouse.getModeComboBox();
        JPanel modePanel = new JPanel();
        modePanel.setBorder(BorderFactory.createTitledBorder("Mouse Mode"));
        modePanel.add(modeBox);
        JPanel scaleGrid = new JPanel(new GridLayout(1, 0));
        scaleGrid.setBorder(BorderFactory.createTitledBorder("Zoom"));
        JPanel labelFeatures = new JPanel(new GridLayout(1, 0));
        labelFeatures.setBorder(BorderFactory.createTitledBorder("Image Effects"));
        JPanel controls = new JPanel();
        scaleGrid.add(plus);
        scaleGrid.add(minus);
        controls.add(scaleGrid);
        labelFeatures.add(shape);
        labelFeatures.add(fill);
        labelFeatures.add(drawOutlines);
        controls.add(labelFeatures);
        controls.add(modePanel);
        content.add((Component)controls, "South");
    }

    private void createGraph(int vertexCount) {
        for (int i = 0; i < vertexCount; ++i) {
            this.graph.addVertex((Object)i);
        }
        int j = 0;
        this.graph.addEdge((Object)j++, (Object)0, (Object)1, EdgeType.DIRECTED);
        this.graph.addEdge((Object)j++, (Object)3, (Object)0, EdgeType.DIRECTED);
        this.graph.addEdge((Object)j++, (Object)0, (Object)4, EdgeType.DIRECTED);
        this.graph.addEdge((Object)j++, (Object)4, (Object)5, EdgeType.DIRECTED);
        this.graph.addEdge((Object)j++, (Object)5, (Object)3, EdgeType.DIRECTED);
        this.graph.addEdge((Object)j++, (Object)2, (Object)1, EdgeType.DIRECTED);
        this.graph.addEdge((Object)j++, (Object)4, (Object)1, EdgeType.DIRECTED);
        this.graph.addEdge((Object)j++, (Object)8, (Object)2, EdgeType.DIRECTED);
        this.graph.addEdge((Object)j++, (Object)3, (Object)8, EdgeType.DIRECTED);
        this.graph.addEdge((Object)j++, (Object)6, (Object)7, EdgeType.DIRECTED);
        this.graph.addEdge((Object)j++, (Object)7, (Object)5, EdgeType.DIRECTED);
        this.graph.addEdge((Object)j++, (Object)0, (Object)9, EdgeType.DIRECTED);
        this.graph.addEdge((Object)j++, (Object)9, (Object)8, EdgeType.DIRECTED);
        this.graph.addEdge((Object)j++, (Object)7, (Object)6, EdgeType.DIRECTED);
        this.graph.addEdge((Object)j++, (Object)6, (Object)5, EdgeType.DIRECTED);
        this.graph.addEdge((Object)j++, (Object)4, (Object)2, EdgeType.DIRECTED);
        this.graph.addEdge((Object)j++, (Object)5, (Object)4, EdgeType.DIRECTED);
        this.graph.addEdge((Object)j++, (Object)4, (Object)10, EdgeType.DIRECTED);
        this.graph.addEdge((Object)j++, (Object)10, (Object)4, EdgeType.DIRECTED);
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        Container content = frame.getContentPane();
        frame.setDefaultCloseOperation(3);
        content.add(new VertexImageShaperDemo());
        frame.pack();
        frame.setVisible(true);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class DemoRenderer<V, E>
    extends BasicVertexRenderer<V, E> {
        DemoRenderer() {
        }

        public void paintIconForVertex(RenderContext<V, E> rc, V v, Layout<V, E> layout) {
            Icon icon;
            Point2D p = (Point2D)layout.transform(v);
            p = rc.getMultiLayerTransformer().transform(Layer.LAYOUT, p);
            float x = (float)p.getX();
            float y = (float)p.getY();
            GraphicsDecorator g = rc.getGraphicsContext();
            boolean outlineImages = false;
            Transformer vertexIconFunction = rc.getVertexIconTransformer();
            if (vertexIconFunction instanceof DemoVertexIconTransformer) {
                outlineImages = ((DemoVertexIconTransformer)vertexIconFunction).isOutlineImages();
            }
            if ((icon = (Icon)vertexIconFunction.transform(v)) == null || outlineImages) {
                Shape s = AffineTransform.getTranslateInstance(x, y).createTransformedShape((Shape)rc.getVertexShapeTransformer().transform(v));
                this.paintShapeForVertex(rc, v, s);
            }
            if (icon != null) {
                int xLoc = (int)(x - (float)(icon.getIconWidth() / 2));
                int yLoc = (int)(y - (float)(icon.getIconHeight() / 2));
                icon.paintIcon(rc.getScreenDevice(), g.getDelegate(), xLoc, yLoc);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DemoVertexIconShapeTransformer<V>
    extends VertexIconShapeTransformer<V> {
        boolean shapeImages = true;

        public DemoVertexIconShapeTransformer(Transformer<V, Shape> delegate) {
            super(delegate);
        }

        public boolean isShapeImages() {
            return this.shapeImages;
        }

        public void setShapeImages(boolean shapeImages) {
            this.shapeMap.clear();
            this.shapeImages = shapeImages;
        }

        public Shape transform(V v) {
            Icon icon = (Icon)this.iconMap.get(v);
            if (icon != null && icon instanceof ImageIcon) {
                Image image = ((ImageIcon)icon).getImage();
                Shape shape = (Shape)this.shapeMap.get(image);
                if (shape == null && (shape = this.shapeImages ? FourPassImageShaper.getShape((Image)image, (int)30) : new Rectangle2D.Float(0.0f, 0.0f, image.getWidth(null), image.getHeight(null))).getBounds().getWidth() > 0.0 && shape.getBounds().getHeight() > 0.0) {
                    int width = image.getWidth(null);
                    int height = image.getHeight(null);
                    AffineTransform transform = AffineTransform.getTranslateInstance(-width / 2, -height / 2);
                    shape = transform.createTransformedShape(shape);
                    this.shapeMap.put(image, shape);
                }
                return shape;
            }
            return (Shape)this.delegate.transform(v);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DemoVertexIconTransformer<V>
    extends DefaultVertexIconTransformer<V>
    implements Transformer<V, Icon> {
        boolean fillImages = true;
        boolean outlineImages = false;

        public boolean isFillImages() {
            return this.fillImages;
        }

        public void setFillImages(boolean fillImages) {
            this.fillImages = fillImages;
        }

        public boolean isOutlineImages() {
            return this.outlineImages;
        }

        public void setOutlineImages(boolean outlineImages) {
            this.outlineImages = outlineImages;
        }

        @Override
        public Icon transform(V v) {
            if (this.fillImages) {
                return (Icon)this.iconMap.get(v);
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class VertexStringerImpl<V, S>
    implements Transformer<V, String> {
        Map<V, String> map = new HashMap<V, String>();
        boolean enabled = true;

        public VertexStringerImpl(Map<V, String> map) {
            this.map = map;
        }

        @Override
        public String transform(V v) {
            if (this.isEnabled()) {
                return this.map.get(v);
            }
            return "";
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PickWithIconListener<V>
    implements ItemListener {
        DefaultVertexIconTransformer<V> imager;
        Icon checked;

        public PickWithIconListener(DefaultVertexIconTransformer<V> imager) {
            this.imager = imager;
            this.checked = new Checkmark();
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            Icon icon = this.imager.transform(e.getItem());
            if (icon != null && icon instanceof LayeredIcon) {
                if (e.getStateChange() == 1) {
                    ((LayeredIcon)icon).add(this.checked);
                } else {
                    ((LayeredIcon)icon).remove(this.checked);
                }
            }
        }
    }
}

