package weka.clusterers.forMetisMQI.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Map.Entry;

import org.apache.commons.collections15.Transformer;

import weka.clusterers.forMetisMQI.graph.Node;

public class ContractedVertexTransformer implements Transformer<Node, String> {
	Map<Node,Set<Node>> mapContracted = null;

	public ContractedVertexTransformer(CoarserGraphElement cge) {
		mapContracted = new HashMap<Node,Set<Node>>();
		Iterator<Entry<Node,Node>> entryIterator = cge.getMap().entrySet().iterator();
		while(entryIterator.hasNext()) {
			Entry<Node, Node> entry = entryIterator.next();
			Node prevNode = entry.getKey();
			Node mappedNode = entry.getValue();
			if(!mapContracted.containsKey(mappedNode))
				mapContracted.put(mappedNode, new HashSet<Node>());
			mapContracted.get(mappedNode).add(prevNode);
		}
	}
	
	public String transform(Node n) {
		StringBuffer buffer = new StringBuffer();
		Iterator<Node> contracted = mapContracted.get(n).iterator();
		buffer.append("[");
		while(contracted.hasNext()) {
			buffer.append(contracted.next().getId() + ", ");
		}
		if(buffer.length() > 1)
			buffer.setLength(buffer.length() - 2);
		buffer.append("]");
		return buffer.toString();
	}

}
