/*
 * Decompiled with CFR 0.152.
 */
package JFlex;

import JFlex.Action;
import JFlex.ErrorMessages;
import JFlex.Macros;
import JFlex.Out;
import JFlex.RegExp;
import JFlex.RegExp1;
import JFlex.RegExp2;
import JFlex.RegExps;
import java.io.File;

public final class SemCheck {
    private static Macros macros;

    public static void check(RegExps rs, Macros m, File f) {
        macros = m;
        int num = rs.getNum();
        for (int i = 0; i < num; ++i) {
            RegExp r = rs.getRegExp(i);
            RegExp l = rs.getLookAhead(i);
            Action a = rs.getAction(i);
            if (r == null || l == null || !SemCheck.maybeEmtpy(r)) continue;
            if (a == null) {
                Out.error(ErrorMessages.EMPTY_MATCH, "");
                continue;
            }
            Out.error(f, ErrorMessages.EMPTY_MATCH, a.priority - 1, -1);
        }
    }

    public static boolean maybeEmtpy(RegExp re) {
        switch (re.type) {
            case 35: {
                RegExp2 r = (RegExp2)re;
                return SemCheck.maybeEmtpy(r.r1) || SemCheck.maybeEmtpy(r.r2);
            }
            case 45: {
                RegExp2 r = (RegExp2)re;
                return SemCheck.maybeEmtpy(r.r1) && SemCheck.maybeEmtpy(r.r2);
            }
            case 33: 
            case 36: {
                return true;
            }
            case 34: {
                RegExp1 r1 = (RegExp1)re;
                return SemCheck.maybeEmtpy((RegExp)r1.content);
            }
            case 40: 
            case 43: 
            case 44: 
            case 47: {
                return false;
            }
            case 41: 
            case 46: {
                String content = (String)((RegExp1)re).content;
                return content.length() == 0;
            }
            case 39: {
                return false;
            }
            case 38: {
                RegExp1 r1 = (RegExp1)re;
                return !SemCheck.maybeEmtpy((RegExp)r1.content);
            }
            case 42: {
                return SemCheck.maybeEmtpy(macros.getDefinition((String)((RegExp1)re).content));
            }
        }
        throw new Error("Unkown expression type " + re.type + " in " + re);
    }

    public static int length(RegExp re) {
        switch (re.type) {
            case 35: {
                RegExp2 r = (RegExp2)re;
                int l1 = SemCheck.length(r.r1);
                if (l1 < 0) {
                    return -1;
                }
                int l2 = SemCheck.length(r.r2);
                if (l1 == l2) {
                    return l1;
                }
                return -1;
            }
            case 45: {
                RegExp2 r = (RegExp2)re;
                int l1 = SemCheck.length(r.r1);
                if (l1 < 0) {
                    return -1;
                }
                int l2 = SemCheck.length(r.r2);
                if (l2 < 0) {
                    return -1;
                }
                return l1 + l2;
            }
            case 33: 
            case 34: 
            case 36: {
                return -1;
            }
            case 40: 
            case 43: 
            case 44: 
            case 47: {
                return 1;
            }
            case 41: 
            case 46: {
                String content = (String)((RegExp1)re).content;
                return content.length();
            }
            case 38: 
            case 39: {
                return -1;
            }
            case 42: {
                return SemCheck.length(macros.getDefinition((String)((RegExp1)re).content));
            }
        }
        throw new Error("Unkown expression type " + re.type + " in " + re);
    }

    public static boolean isFiniteChoice(RegExp re) {
        switch (re.type) {
            case 35: {
                RegExp2 r = (RegExp2)re;
                return SemCheck.isFiniteChoice(r.r1) && SemCheck.isFiniteChoice(r.r2);
            }
            case 45: {
                RegExp2 r = (RegExp2)re;
                int l1 = SemCheck.length(r.r1);
                if (l1 < 0) {
                    return false;
                }
                int l2 = SemCheck.length(r.r2);
                return l2 >= 0;
            }
            case 33: 
            case 34: 
            case 36: {
                return false;
            }
            case 40: 
            case 43: 
            case 44: 
            case 47: {
                return true;
            }
            case 41: 
            case 46: {
                return true;
            }
            case 38: 
            case 39: {
                return false;
            }
            case 42: {
                return SemCheck.isFiniteChoice(macros.getDefinition((String)((RegExp1)re).content));
            }
        }
        throw new Error("Unkown expression type " + re.type + " in " + re);
    }
}

