/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.BHInsertStructure;
import javax.media.j3d.BHNode;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.FreeListManager;

class BHInternalNode
extends BHNode {
    static boolean debug2 = true;
    BHNode rChild;
    BHNode lChild;

    BHInternalNode() {
        this.nodeType = 1;
        this.rChild = null;
        this.lChild = null;
    }

    BHInternalNode(BHNode bHNode) {
        super(bHNode);
        this.nodeType = 1;
        this.rChild = null;
        this.lChild = null;
    }

    BHInternalNode(BHNode bHNode, BHNode bHNode2, BHNode bHNode3) {
        super(bHNode);
        this.nodeType = 1;
        this.rChild = bHNode2;
        this.lChild = bHNode3;
    }

    BHInternalNode(BHNode bHNode, BoundingBox boundingBox) {
        super(bHNode, boundingBox);
        this.nodeType = 1;
        this.rChild = null;
        this.lChild = null;
    }

    BHInternalNode(BHNode bHNode, BHNode bHNode2, BHNode bHNode3, BoundingBox boundingBox) {
        super(bHNode, boundingBox);
        this.nodeType = 1;
        this.rChild = bHNode2;
        this.lChild = bHNode3;
    }

    BHNode getLeftChild() {
        return this.lChild;
    }

    BHNode getRightChild() {
        return this.rChild;
    }

    void setLeftChild(BHNode bHNode) {
        this.lChild = bHNode;
    }

    void setRightChild(BHNode bHNode) {
        this.rChild = bHNode;
    }

    void computeBoundingHull(BoundingBox boundingBox) {
        this.computeBoundingHull();
        boundingBox.set(this.bHull);
    }

    void computeBoundingHull() {
        BoundingBox boundingBox = null;
        BoundingBox boundingBox2 = null;
        if (this.lChild == null && this.rChild == null) {
            this.bHull = null;
            return;
        }
        if (this.lChild != null) {
            boundingBox2 = this.lChild.getBoundingHull();
        }
        if (this.rChild != null) {
            boundingBox = this.rChild.getBoundingHull();
        }
        if (this.bHull == null) {
            this.bHull = new BoundingBox();
        }
        if (this.lChild == null) {
            this.bHull.set(boundingBox);
            return;
        }
        if (this.rChild == null) {
            this.bHull.set(boundingBox2);
            return;
        }
        this.bHull.set(boundingBox);
        this.bHull.combine(boundingBox2);
    }

    void updateMarkedBoundingHull() {
        if (!this.mark) {
            return;
        }
        this.rChild.updateMarkedBoundingHull();
        this.lChild.updateMarkedBoundingHull();
        this.computeBoundingHull();
        this.mark = false;
    }

    void insert(BHNode bHNode, BHInsertStructure bHInsertStructure) {
        if (debug2 && !this.isInside(bHNode.bHull)) {
            System.out.println("Incorrect use of insertion, current node");
            System.out.println("must contain the input element ...");
        }
        boolean bl = false;
        boolean bl2 = false;
        bl = this.rChild.nodeType == 2 ? false : this.rChild.isInside(bHNode.bHull);
        bl2 = this.lChild.nodeType == 2 ? false : this.lChild.isInside(bHNode.bHull);
        if (bl2 && !bl) {
            ((BHInternalNode)this.lChild).insert(bHNode, bHInsertStructure);
        } else if (!bl2 && bl) {
            ((BHInternalNode)this.rChild).insert(bHNode, bHInsertStructure);
        } else if (bl2 && bl) {
            if (bHInsertStructure.randomNumber.nextBoolean()) {
                ((BHInternalNode)this.lChild).insert(bHNode, bHInsertStructure);
            } else {
                ((BHInternalNode)this.rChild).insert(bHNode, bHInsertStructure);
            }
        } else {
            bHInsertStructure.lookupAndInsert(this, bHNode);
        }
    }

    void destroyTree(BHNode[] bHNodeArray, int[] nArray) {
        if (this.rChild != null) {
            this.rChild.destroyTree(bHNodeArray, nArray);
        }
        if (this.lChild != null) {
            this.lChild.destroyTree(bHNodeArray, nArray);
        }
        this.rChild = null;
        this.lChild = null;
        FreeListManager.freeObject(3, this);
    }
}

