package weka.clusterers.forMetisMQI;


public class Node {

	private String id;

	/** The weight of the node */
	private int vwgt;
	/** The size of the adjacency list of the node */
	private int nedges;
	/**
	 * The index into the adjacency list that is the beginning of the adjacency
	 * list of v
	 */
	private int iedges;
	/** The weight of the edges that have been contracted to create the node */
	private int cewgt;
	/** The sum of the weight of the edges adjacent to v */
	private int adjwgt;

	public Node(String id) {
		this.id = id;
		this.vwgt = 1;
		this.cewgt = 0;
		this.iedges = 0;
		this.nedges = 0;
		this.adjwgt = 0;
	}

	@Override
	public boolean equals(Object o) {
		return (o instanceof Node) && (((Node) o).getId().equals(id));
	}

	@Override
	public int hashCode() {
		int hash = 1;
		hash = hash * 31 + id.hashCode();
		return hash;
	}

	public String getId() {
		return id;
	}

	@Override
	public String toString() {
		return "N" + id;
	}

	public int getVwgt() {
		return vwgt;
	}

	public void setVwgt(int vwgt) {
		this.vwgt = vwgt;
	}

	public int getNedges() {
		return nedges;
	}

	public void setNedges(int nedges) {
		this.nedges = nedges;
	}

	public int getIedges() {
		return iedges;
	}

	public void setIedges(int iedges) {
		this.iedges = iedges;
	}

	public int getCewgt() {
		return cewgt;
	}

	public void setCewgt(int cewgt) {
		this.cewgt = cewgt;
	}

	public int getAdjwgt() {
		return adjwgt;
	}

	public void setAdjwgt(int adjwgt) {
		this.adjwgt = adjwgt;
	}
	
	@Override
	public Node clone() {
		Node n = new Node(id);
		n.adjwgt = adjwgt;
		n.cewgt = cewgt;
		n.iedges = iedges;
		n.nedges = nedges;
		n.vwgt = vwgt;
		return n;
	}

}
