package weka.clusterers.forMetisMQI;

public class Edge {
	
	private String id;
	
	private int weight;
	
	private int capacity;
	
	public Edge(String id, int weight, int capacity) {
		this.id = id;
		this.weight = weight;
		this.capacity = capacity;
	}
	
	@Override
	public int hashCode() {
		int hash = 1;
		hash = hash * 31 + id.hashCode();
		return hash;
	}
	
	@Override
	public boolean equals(Object o) {
		boolean result = (o instanceof Edge);
		if(result) {
			Edge e = (Edge) o;
			result = result && (e.getId().equals(id));
			result = result && (e.getWeight() == weight);
			result = result && (e.getCapacity() == capacity);
		}
		return result;
	}

	public String getId() {
		return id;
	}
	
	public int getWeight() {
		return weight;
	}
	
	public int getCapacity() {
		return capacity;
	}
	
	@Override
	public String toString() {
		return "E" + id;
	}

	public void setWeight(int weight) {
		this.weight = weight;
	}

	public void setCapacity(int capacity) {
		this.capacity = capacity;
	}
	
	@Override
	public Edge clone(){
		Edge e = new Edge(id, weight, capacity);
		return e;
	}

}
