/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.BHLeafInterface;
import javax.media.j3d.BHLeafNode;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.GeometryRetained;
import javax.media.j3d.Locale;
import javax.media.j3d.NnuId;
import javax.media.j3d.NnuIdManager;
import javax.media.j3d.RenderAtom;
import javax.media.j3d.RenderAtomListInfo;
import javax.media.j3d.Shape3DRetained;
import javax.media.j3d.Transform3D;
import javax.media.j3d.View;
import javax.media.j3d.VirtualUniverse;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;

class GeometryAtom
implements BHLeafInterface,
NnuId {
    GeometryRetained[] geometryArray = null;
    Transform3D[] lastLocalTransformArray = null;
    Locale locale = null;
    Shape3DRetained source = null;
    BHLeafNode bhLeafNode = null;
    boolean alphaEditable;
    boolean visible = true;
    int geoType = -1;
    RenderAtom[] renderAtoms = new RenderAtom[0];
    int nnuId;
    Point3d[] centroid = null;
    boolean centroidIsDirty = true;
    Object lockObj = new Object();

    GeometryAtom() {
        this.nnuId = NnuIdManager.getId();
    }

    public int getId() {
        return this.nnuId;
    }

    public int equal(NnuId nnuId) {
        int n = nnuId.getId();
        if (this.nnuId < n) {
            return -1;
        }
        if (this.nnuId > n) {
            return 1;
        }
        return 0;
    }

    public BoundingBox computeBoundingHull() {
        return this.source.vwcBounds;
    }

    public boolean isEnable() {
        return this.source.vwcBounds != null && !this.source.vwcBounds.isEmpty() && this.source.switchState.currentSwitchOn;
    }

    public boolean isEnable(int n) {
        if (this.source.vwcBounds != null && !this.source.vwcBounds.isEmpty() && this.source.switchState.currentSwitchOn) {
            switch (n) {
                case 0: {
                    return this.visible;
                }
                case 1: {
                    return !this.visible;
                }
                case 2: {
                    return true;
                }
            }
        }
        return false;
    }

    public Locale getLocale2() {
        return this.locale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    RenderAtom getRenderAtom(View view) {
        int n;
        RenderAtom[] renderAtomArray = this.renderAtoms;
        synchronized (renderAtomArray) {
            n = view.viewIndex;
            if (n >= this.renderAtoms.length) {
                RenderAtom renderAtom;
                if (this.source.viewList != null && !this.source.viewList.contains(view)) {
                    RenderAtom renderAtom2 = null;
                    return renderAtom2;
                }
                RenderAtom[] renderAtomArray2 = new RenderAtom[n + 1];
                int n2 = 0;
                while (n2 < this.renderAtoms.length) {
                    renderAtomArray2[n2] = this.renderAtoms[n2];
                    ++n2;
                }
                renderAtomArray2[n] = renderAtom = new RenderAtom();
                renderAtomArray2[n].geometryAtom = this;
                renderAtom.rListInfo = new RenderAtomListInfo[this.geometryArray.length];
                if (this.geoType != 16) {
                    int n3 = 0;
                    while (n3 < renderAtom.rListInfo.length) {
                        renderAtom.rListInfo[n3] = new RenderAtomListInfo();
                        renderAtom.rListInfo[n3].renderAtom = renderAtom;
                        renderAtom.rListInfo[n3].index = n3;
                        ++n3;
                    }
                } else {
                    int n4 = 0;
                    while (n4 < renderAtom.rListInfo.length) {
                        renderAtom.rListInfo[n4] = new RenderAtomListInfo();
                        renderAtom.rListInfo[n4].renderAtom = renderAtom;
                        renderAtom.rListInfo[n4].index = n4;
                        renderAtom.rListInfo[n4].localToVworld = VirtualUniverse.mc.getTransform3D(null);
                        ++n4;
                    }
                }
                this.renderAtoms = renderAtomArray2;
            } else if (this.renderAtoms[n] == null) {
                RenderAtom renderAtom;
                if (this.source.viewList != null && !this.source.viewList.contains(view)) {
                    RenderAtom renderAtom3 = null;
                    return renderAtom3;
                }
                this.renderAtoms[n] = renderAtom = new RenderAtom();
                this.renderAtoms[n].geometryAtom = this;
                renderAtom.rListInfo = new RenderAtomListInfo[this.geometryArray.length];
                if (this.geoType != 16) {
                    int n5 = 0;
                    while (n5 < renderAtom.rListInfo.length) {
                        renderAtom.rListInfo[n5] = new RenderAtomListInfo();
                        renderAtom.rListInfo[n5].renderAtom = renderAtom;
                        renderAtom.rListInfo[n5].index = n5;
                        ++n5;
                    }
                } else {
                    int n6 = 0;
                    while (n6 < renderAtom.rListInfo.length) {
                        renderAtom.rListInfo[n6] = new RenderAtomListInfo();
                        renderAtom.rListInfo[n6].renderAtom = renderAtom;
                        renderAtom.rListInfo[n6].index = n6;
                        renderAtom.rListInfo[n6].localToVworld = VirtualUniverse.mc.getTransform3D(null);
                        ++n6;
                    }
                }
            }
        }
        return this.renderAtoms[n];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateCentroid() {
        Object object = this.lockObj;
        synchronized (object) {
            int n = 0;
            while (n < this.geometryArray.length) {
                if (this.geometryArray[n] != null) {
                    Point3d point3d = this.geometryArray[n].centroid;
                    synchronized (point3d) {
                        if (this.geometryArray[n].recompCentroid) {
                            this.geometryArray[n].computeCentroid();
                            this.geometryArray[n].recompCentroid = false;
                        }
                    }
                }
                ++n;
            }
            if (this.centroidIsDirty) {
                if (this.centroid == null) {
                    this.centroid = new Point3d[this.geometryArray.length];
                    int n2 = 0;
                    while (n2 < this.centroid.length) {
                        if (this.geometryArray[n2] != null) {
                            this.centroid[n2] = new Point3d(this.geometryArray[n2].centroid);
                            this.source.getCurrentLocalToVworld(0).transform(this.centroid[n2]);
                        }
                        ++n2;
                    }
                } else {
                    int n3 = 0;
                    while (n3 < this.centroid.length) {
                        if (this.geometryArray[n3] != null) {
                            this.centroid[n3].set((Tuple3d)this.geometryArray[n3].centroid);
                            this.source.getCurrentLocalToVworld(0).transform(this.centroid[n3]);
                        }
                        ++n3;
                    }
                }
                this.centroidIsDirty = false;
            }
        }
    }
}

