/*
 * Decompiled with CFR 0.152.
 */
package view;

import clustering.VertexScore;
import edu.uci.ics.jung.algorithms.layout.FRLayout;
import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.visualization.BasicVisualizationServer;
import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import javax.swing.JFrame;
import view.VertexLabelTransformer;
import view.VertexPaintRankTransformer;
import view.VertexPaintTransformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Viewer<V, E> {
    Graph<V, E> graph;
    Layout<V, E> layout;
    BasicVisualizationServer<V, E> vv;
    JFrame frame;

    public Viewer(Graph<V, E> graph) {
        this.graph = graph;
        this.frame = null;
        this.frame = new JFrame("Graph View");
        this.frame.setDefaultCloseOperation(3);
        this.layout = new FRLayout(graph);
        this.layout.setSize(new Dimension(1000, 700));
        this.vv = new BasicVisualizationServer(this.layout);
        this.vv.setPreferredSize(new Dimension(1000, 700));
        this.vv.getRenderContext().setVertexLabelTransformer(new VertexLabelTransformer());
    }

    public void setGraph(Graph<V, E> graph) {
        this.graph = graph;
        this.layout.setGraph(graph);
        this.frame.repaint();
    }

    public void viewGraphRank(List<VertexScore<V>> pagerank, List<V> cluster) {
        VertexPaintRankTransformer vertexPaint = new VertexPaintRankTransformer(pagerank, cluster);
        this.vv.getRenderContext().setVertexFillPaintTransformer(vertexPaint);
        this.frame.getContentPane().add((Component)this.vv);
        this.frame.pack();
        this.frame.repaint();
        this.frame.setVisible(true);
    }

    public void viewGraph(List<V> cut) {
        if (cut != null) {
            VertexPaintTransformer vertexPaint = new VertexPaintTransformer(cut);
            this.vv.getRenderContext().setVertexFillPaintTransformer(vertexPaint);
        }
        this.frame.getContentPane().add((Component)this.vv);
        this.frame.pack();
        this.frame.repaint();
        this.frame.setVisible(true);
    }
}

