/*
 * Decompiled with CFR 0.152.
 */
package clustering;

import clustering.Edge;
import clustering.LocalSpectral;
import clustering.VertexScore;
import data.GraphBuilder;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.SparseGraph;
import java.util.Collection;
import java.util.List;
import view.Viewer;

public class GraphClusterer {
    public void clusterize(int min_volume, String path) {
        GraphBuilder builder = new GraphBuilder();
        builder.buildGraphFromARFF(path, 100000);
        Graph<String, Edge<String>> graph = builder.getGraph();
        LocalSpectral<String, Edge<String>> clusterer = new LocalSpectral<String, Edge<String>>(graph);
        List global_ranking = clusterer.getGlobalRank();
        System.out.println("GLOBAL RANKING");
        for (VertexScore<String> vertexScore : global_ranking) {
            System.out.println(vertexScore.toString());
        }
        Viewer<String, Edge<String>> viewGraph = new Viewer<String, Edge<String>>(graph);
        viewGraph.viewGraphRank(global_ranking, null);
        for (VertexScore v : global_ranking) {
            Long stoptime = 5000L;
            try {
                Thread.sleep(stoptime);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            List<String> cut = clusterer.clusterPageRankPriors((String)v.getVertex(), min_volume);
            SparseGraph cut_graph = new SparseGraph();
            for (String vertex : cut) {
                Collection out_edges = graph.getOutEdges((Object)vertex);
                for (Edge edge : out_edges) {
                    String out_node = (String)edge.getVertex2();
                    if (!cut.contains(out_node)) continue;
                    cut_graph.addEdge((Object)edge, edge.getVertex1(), edge.getVertex2());
                }
            }
            viewGraph.setGraph((Graph<String, Edge<String>>)cut_graph);
            viewGraph.viewGraph(null);
            try {
                Thread.sleep(stoptime);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            viewGraph.setGraph(graph);
            viewGraph.viewGraphRank(global_ranking, null);
        }
    }
}

