
package view;

import clustering.VertexScore;
import clustering.VertexString;
import edu.uci.ics.jung.algorithms.layout.FRLayout;
import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.visualization.BasicVisualizationServer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import org.apache.commons.collections15.Transformer;



public class Viewer<V,E> {

    Graph<V,E> graph;
    Layout<V, E> layout;
    BasicVisualizationServer<V,E> vv;
    JFrame frame;

    public Viewer(Graph<V,E> graph) {
        this.graph = graph;
        this.frame = new JFrame("Graph View");
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        layout = new FRLayout(graph);
        layout.setSize(new Dimension(1000,700));
        vv = new BasicVisualizationServer(layout);
        vv.setPreferredSize(new Dimension(1000,700));
        vv.getRenderContext().setVertexLabelTransformer(new VertexLabelTransformer<V, String>());
    }

    public void setGraph(Graph<V, E> graph) {
        this.graph = graph;
        layout.setGraph(graph);
        frame.repaint();
    }
    
    public void viewGraphRank(List<VertexScore<V>> pagerank, List<V> cluster){
         VertexPaintRankTransformer vertexPaint = new VertexPaintRankTransformer(pagerank,cluster);
         vv.getRenderContext().setVertexFillPaintTransformer((Transformer<V, Paint>) vertexPaint);
         
         frame.getContentPane().add(vv);
         frame.pack();
         frame.repaint();
         frame.setVisible(true);
    }


    public void viewGraph(List<V> cut){
        
         if(cut != null){
             VertexPaintTransformer<V,Paint> vertexPaint = new VertexPaintTransformer<V, Paint>(cut);
             vv.getRenderContext().setVertexFillPaintTransformer(vertexPaint);
         }
         
         frame.getContentPane().add(vv);
         frame.pack();
         frame.repaint();
         frame.setVisible(true);

     }
}
