
package jung;

import clustering.Edge;
import clustering.LocalSpectral;
import clustering.VertexScore;
import clustering.VertexString;
import data.GraphBuilder;
import edu.uci.ics.jung.algorithms.scoring.PageRank;
import edu.uci.ics.jung.graph.AbstractGraph;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.SparseGraph;
import java.awt.Paint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import view.VertexPaintTransformer;
import view.Viewer;

public class Main {

    public static void main(String[] args) {
       GraphBuilder builder = new GraphBuilder();
       builder.buildGraphFromARFF("/home/luke/Desktop/reteUtentiMikeHidden.arff", 1000);
       //builder.buildGraphFromARFF("/home/luke/Desktop/reteSemplice.txt", 10000);
       Graph<String, Edge<String>> graph = builder.getGraph();

       LocalSpectral<String,Edge<String>> clusterer = new LocalSpectral(graph);
       List<VertexScore<String>> global_ranking = clusterer.getGlobalRank();

       System.out.println("GLOBAL RANKING");
       for(VertexScore<String> v : global_ranking)
           System.out.println(v.toString());
       
       Viewer viewGraph = new Viewer(graph);
       viewGraph.viewGraphRank(global_ranking,null);
       //viewGraph.viewGraph(null);

       
       for(VertexScore<String> v : global_ranking){
           Long stoptime = 5000L; 
           try {
                Thread.sleep(stoptime);
            } catch (InterruptedException e) {}
           List<String> cut = clusterer.clusterPageRankPriors(v.getVertex(),6);
           Graph<String,Edge<String>> cut_graph = new SparseGraph<String, Edge<String>>();
           for(String vertex : cut){
               Collection<Edge<String>> out_edges = graph.getOutEdges(vertex);
               for(Edge<String> edge : out_edges){
                   String out_node = edge.getVertex2();
                   if (cut.contains(out_node)){
                       cut_graph.addEdge(edge, edge.getVertex1(),edge.getVertex2());
                   }
               }
           }
           viewGraph.setGraph(cut_graph);
           viewGraph.viewGraph(null);
           try {
                Thread.sleep(stoptime);
           } catch (InterruptedException e) {}
           viewGraph.setGraph(graph);
           viewGraph.viewGraphRank(global_ranking, null);
       }
        

    }


}
