/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.IntegerFreeList;
import javax.media.j3d.MemoryFreeList;

class FreeListManager {
    private static final boolean DEBUG = false;
    static final int MESSAGE = 0;
    static final int BHLEAF = 1;
    static final int TRANSFORM3D = 2;
    static final int BHINTERNAL = 3;
    static final int DISPLAYLIST = 4;
    static final int TEXTURE2D = 5;
    static final int TEXTURE3D = 6;
    static final int CANVASBIT = 7;
    static final int VECTOR3D = 8;
    static final int POINT3D = 9;
    static int MAXINT = 9;
    private static int currlist = 0;
    static MemoryFreeList[] freelist = new MemoryFreeList[MAXINT + 1];

    FreeListManager() {
    }

    static void createFreeLists() {
        FreeListManager.freelist[0] = new MemoryFreeList("javax.media.j3d.J3dMessage");
        FreeListManager.freelist[1] = new MemoryFreeList("javax.media.j3d.BHLeafNode");
        FreeListManager.freelist[2] = new MemoryFreeList("javax.media.j3d.Transform3D");
        FreeListManager.freelist[3] = new MemoryFreeList("javax.media.j3d.BHInternalNode");
        FreeListManager.freelist[4] = new IntegerFreeList();
        FreeListManager.freelist[5] = new IntegerFreeList();
        FreeListManager.freelist[6] = new IntegerFreeList();
        FreeListManager.freelist[7] = new IntegerFreeList();
        FreeListManager.freelist[9] = new MemoryFreeList("javax.vecmath.Point3d");
        FreeListManager.freelist[8] = new MemoryFreeList("javax.vecmath.Vector3d");
    }

    static int createNewFreeList(String string) {
        MemoryFreeList[] memoryFreeListArray = freelist;
        freelist = new MemoryFreeList[++MAXINT + 1];
        System.arraycopy(memoryFreeListArray, 0, freelist, 0, MAXINT + 1);
        FreeListManager.freelist[FreeListManager.MAXINT] = new MemoryFreeList(string);
        return MAXINT;
    }

    static void manageLists() {
        if (freelist[currlist] != null) {
            freelist[currlist].shrink();
        }
        if (++currlist > MAXINT) {
            currlist = 0;
        }
    }

    static MemoryFreeList getFreeList(int n) {
        if (n < 0 || n > MAXINT) {
            return null;
        }
        return freelist[n];
    }

    static Object getObject(int n) {
        return freelist[n].getObject();
    }

    static void freeObject(int n, Object object) {
        freelist[n].add(object);
    }

    static void clearList(int n) {
        freelist[n].clear();
    }
}

