/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.samples;

import edu.uci.ics.jung.algorithms.layout.FRLayout;
import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.graph.DirectedSparseGraph;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.util.EdgeType;
import edu.uci.ics.jung.visualization.GraphZoomScrollPane;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.CrossoverScalingControl;
import edu.uci.ics.jung.visualization.control.DefaultModalGraphMouse;
import edu.uci.ics.jung.visualization.control.ScalingControl;
import edu.uci.ics.jung.visualization.decorators.DefaultVertexIconTransformer;
import edu.uci.ics.jung.visualization.decorators.EllipseVertexShapeTransformer;
import edu.uci.ics.jung.visualization.decorators.PickableEdgePaintTransformer;
import edu.uci.ics.jung.visualization.decorators.PickableVertexPaintTransformer;
import edu.uci.ics.jung.visualization.decorators.ToStringLabeller;
import edu.uci.ics.jung.visualization.decorators.VertexIconShapeTransformer;
import edu.uci.ics.jung.visualization.picking.PickedInfo;
import edu.uci.ics.jung.visualization.renderers.DefaultEdgeLabelRenderer;
import edu.uci.ics.jung.visualization.renderers.DefaultVertexLabelRenderer;
import edu.uci.ics.jung.visualization.renderers.EdgeLabelRenderer;
import edu.uci.ics.jung.visualization.renderers.VertexLabelRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.apache.commons.collections15.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnicodeLabelDemo {
    Graph<Integer, Number> graph = new DirectedSparseGraph();
    VisualizationViewer<Integer, Number> vv;
    boolean showLabels;

    public UnicodeLabelDemo() {
        Integer[] v = this.createVertices(10);
        this.createEdges(v);
        this.vv = new VisualizationViewer((Layout)new FRLayout(this.graph));
        this.vv.getRenderContext().setVertexLabelTransformer(new UnicodeVertexStringer<Integer>(v));
        this.vv.getRenderContext().setVertexLabelRenderer((VertexLabelRenderer)new DefaultVertexLabelRenderer(Color.cyan));
        this.vv.getRenderContext().setEdgeLabelRenderer((EdgeLabelRenderer)new DefaultEdgeLabelRenderer(Color.cyan));
        VertexIconShapeTransformer vertexIconShapeFunction = new VertexIconShapeTransformer((Transformer)new EllipseVertexShapeTransformer());
        DefaultVertexIconTransformer vertexIconFunction = new DefaultVertexIconTransformer();
        this.vv.getRenderContext().setVertexShapeTransformer((Transformer)vertexIconShapeFunction);
        this.vv.getRenderContext().setVertexIconTransformer((Transformer)vertexIconFunction);
        this.loadImages(v, vertexIconFunction.getIconMap());
        vertexIconShapeFunction.setIconMap(vertexIconFunction.getIconMap());
        this.vv.getRenderContext().setVertexFillPaintTransformer((Transformer)new PickableVertexPaintTransformer((PickedInfo)this.vv.getPickedVertexState(), (Paint)Color.white, (Paint)Color.yellow));
        this.vv.getRenderContext().setEdgeDrawPaintTransformer((Transformer)new PickableEdgePaintTransformer((PickedInfo)this.vv.getPickedEdgeState(), (Paint)Color.black, (Paint)Color.lightGray));
        this.vv.setBackground(Color.white);
        this.vv.setVertexToolTipTransformer((Transformer)new ToStringLabeller());
        JFrame frame = new JFrame();
        Container content = frame.getContentPane();
        GraphZoomScrollPane panel = new GraphZoomScrollPane(this.vv);
        content.add((Component)panel);
        frame.setDefaultCloseOperation(3);
        DefaultModalGraphMouse gm = new DefaultModalGraphMouse();
        this.vv.setGraphMouse((VisualizationViewer.GraphMouse)gm);
        CrossoverScalingControl scaler = new CrossoverScalingControl();
        JButton plus = new JButton("+");
        plus.addActionListener(new ActionListener((ScalingControl)scaler){
            final /* synthetic */ ScalingControl val$scaler;
            {
                this.val$scaler = scalingControl;
            }

            public void actionPerformed(ActionEvent e) {
                this.val$scaler.scale(UnicodeLabelDemo.this.vv, 1.1f, UnicodeLabelDemo.this.vv.getCenter());
            }
        });
        JButton minus = new JButton("-");
        minus.addActionListener(new ActionListener((ScalingControl)scaler){
            final /* synthetic */ ScalingControl val$scaler;
            {
                this.val$scaler = scalingControl;
            }

            public void actionPerformed(ActionEvent e) {
                this.val$scaler.scale(UnicodeLabelDemo.this.vv, 0.9090909f, UnicodeLabelDemo.this.vv.getCenter());
            }
        });
        JCheckBox lo = new JCheckBox("Show Labels");
        lo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                UnicodeLabelDemo.this.showLabels = e.getStateChange() == 1;
                UnicodeLabelDemo.this.vv.repaint();
            }
        });
        lo.setSelected(true);
        JPanel controls = new JPanel();
        controls.add(plus);
        controls.add(minus);
        controls.add(lo);
        controls.add(gm.getModeComboBox());
        content.add((Component)controls, "South");
        frame.pack();
        frame.setVisible(true);
    }

    private Integer[] createVertices(int count) {
        Integer[] v = new Integer[count];
        for (int i = 0; i < count; ++i) {
            v[i] = new Integer(i);
            this.graph.addVertex(v[i]);
        }
        return v;
    }

    void createEdges(Integer[] v) {
        this.graph.addEdge(new Double(Math.random()), v[0], v[1], EdgeType.DIRECTED);
        this.graph.addEdge(new Double(Math.random()), v[0], v[3], EdgeType.DIRECTED);
        this.graph.addEdge(new Double(Math.random()), v[0], v[4], EdgeType.DIRECTED);
        this.graph.addEdge(new Double(Math.random()), v[4], v[5], EdgeType.DIRECTED);
        this.graph.addEdge(new Double(Math.random()), v[3], v[5], EdgeType.DIRECTED);
        this.graph.addEdge(new Double(Math.random()), v[1], v[2], EdgeType.DIRECTED);
        this.graph.addEdge(new Double(Math.random()), v[1], v[4], EdgeType.DIRECTED);
        this.graph.addEdge(new Double(Math.random()), v[8], v[2], EdgeType.DIRECTED);
        this.graph.addEdge(new Double(Math.random()), v[3], v[8], EdgeType.DIRECTED);
        this.graph.addEdge(new Double(Math.random()), v[6], v[7], EdgeType.DIRECTED);
        this.graph.addEdge(new Double(Math.random()), v[7], v[5], EdgeType.DIRECTED);
        this.graph.addEdge(new Double(Math.random()), v[0], v[9], EdgeType.DIRECTED);
        this.graph.addEdge(new Double(Math.random()), v[9], v[8], EdgeType.DIRECTED);
        this.graph.addEdge(new Double(Math.random()), v[7], v[6], EdgeType.DIRECTED);
        this.graph.addEdge(new Double(Math.random()), v[6], v[5], EdgeType.DIRECTED);
        this.graph.addEdge(new Double(Math.random()), v[4], v[2], EdgeType.DIRECTED);
        this.graph.addEdge(new Double(Math.random()), v[5], v[4], EdgeType.DIRECTED);
    }

    protected void loadImages(Integer[] vertices, Map<Integer, Icon> imageMap) {
        ImageIcon[] icons = null;
        try {
            icons = new ImageIcon[]{new ImageIcon(this.getClass().getResource("/images/united-states.gif")), new ImageIcon(this.getClass().getResource("/images/china.gif")), new ImageIcon(this.getClass().getResource("/images/russia.gif")), new ImageIcon(this.getClass().getResource("/images/france.gif")), new ImageIcon(this.getClass().getResource("/images/germany.gif")), new ImageIcon(this.getClass().getResource("/images/japan.gif")), new ImageIcon(this.getClass().getResource("/images/spain.gif"))};
        }
        catch (Exception ex) {
            System.err.println("You need flags.jar in your classpath to see the flag icons.");
        }
        for (int i = 0; icons != null && i < vertices.length; ++i) {
            imageMap.put(vertices[i], (Icon)icons[i % icons.length]);
        }
    }

    public static void main(String[] args) {
        new UnicodeLabelDemo();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class UnicodeVertexStringer<V>
    implements Transformer<V, String> {
        Map<V, String> map = new HashMap<V, String>();
        Map<V, Icon> iconMap = new HashMap<V, Icon>();
        String[] labels = new String[]{"Welcome to JUNG!", "\u6b22\u8fce\u4f7f\u7528  JUNG!", "\u0414\u043e\u0431\u0440\u043e \u043f\u043e\u0436\u0430\u043b\u043e\u0432\u0430\u0422\u044a \u0432 JUNG!", "Bienvenue au JUNG!", "Wilkommen zu JUNG!", "JUNG\u3078\u3087\u3045\u3053\u305d!", "Bienvenida a JUNG!"};

        public UnicodeVertexStringer(V[] vertices) {
            for (int i = 0; i < vertices.length; ++i) {
                this.map.put((String)vertices[i], this.labels[i % this.labels.length]);
            }
        }

        public String getLabel(V v) {
            if (UnicodeLabelDemo.this.showLabels) {
                return this.map.get(v);
            }
            return "";
        }

        @Override
        public String transform(V input) {
            return this.getLabel(input);
        }
    }
}

