/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections15.bag;

import java.util.Set;
import org.apache.commons.collections15.Bag;
import org.apache.commons.collections15.collection.SynchronizedCollection;
import org.apache.commons.collections15.set.SynchronizedSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynchronizedBag<E>
extends SynchronizedCollection<E>
implements Bag<E> {
    private static final long serialVersionUID = 8084674570753837109L;

    public static <E> Bag<E> decorate(Bag<E> bag) {
        return new SynchronizedBag<E>(bag);
    }

    protected SynchronizedBag(Bag<E> bag) {
        super(bag);
    }

    protected SynchronizedBag(Bag<E> bag, Object lock) {
        super(bag, lock);
    }

    protected Bag<E> getBag() {
        return (Bag)this.collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(E object, int count) {
        Object object2 = this.lock;
        synchronized (object2) {
            return this.getBag().add(object, count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(E object, int count) {
        Object object2 = this.lock;
        synchronized (object2) {
            return this.getBag().remove(object, count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<E> uniqueSet() {
        Object object = this.lock;
        synchronized (object) {
            Set<E> set = this.getBag().uniqueSet();
            return new SynchronizedBagSet(set, this.lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getCount(E object) {
        Object object2 = this.lock;
        synchronized (object2) {
            return this.getBag().getCount(object);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class SynchronizedBagSet
    extends SynchronizedSet<E> {
        SynchronizedBagSet(Set<E> set, Object lock) {
            super(set, lock);
        }
    }
}

