/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.io.graphml.parser;

import edu.uci.ics.jung.graph.Hypergraph;
import edu.uci.ics.jung.io.graphml.EdgeMetadata;
import edu.uci.ics.jung.io.graphml.GraphMetadata;
import edu.uci.ics.jung.io.graphml.HyperEdgeMetadata;
import edu.uci.ics.jung.io.graphml.KeyMap;
import edu.uci.ics.jung.io.graphml.NodeMetadata;
import edu.uci.ics.jung.io.graphml.parser.ElementParserRegistry;
import org.apache.commons.collections15.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParserContext<G extends Hypergraph<V, E>, V, E> {
    private final KeyMap keyMap;
    private final ElementParserRegistry<G, V, E> elementParserRegistry;
    private final Transformer<GraphMetadata, G> graphTransformer;
    private final Transformer<NodeMetadata, V> vertexTransformer;
    private final Transformer<EdgeMetadata, E> edgeTransformer;
    private final Transformer<HyperEdgeMetadata, E> hyperEdgeTransformer;

    public ParserContext(ElementParserRegistry<G, V, E> elementParserRegistry, KeyMap keyMap, Transformer<GraphMetadata, G> graphTransformer, Transformer<NodeMetadata, V> vertexTransformer, Transformer<EdgeMetadata, E> edgeTransformer, Transformer<HyperEdgeMetadata, E> hyperEdgeTransformer) {
        this.elementParserRegistry = elementParserRegistry;
        this.keyMap = keyMap;
        this.graphTransformer = graphTransformer;
        this.vertexTransformer = vertexTransformer;
        this.edgeTransformer = edgeTransformer;
        this.hyperEdgeTransformer = hyperEdgeTransformer;
    }

    public ElementParserRegistry<G, V, E> getElementParserRegistry() {
        return this.elementParserRegistry;
    }

    public KeyMap getKeyMap() {
        return this.keyMap;
    }

    public G createGraph(GraphMetadata metadata) {
        return (G)((Hypergraph)this.graphTransformer.transform(metadata));
    }

    public V createVertex(NodeMetadata metadata) {
        return this.vertexTransformer.transform(metadata);
    }

    public E createEdge(EdgeMetadata metadata) {
        return this.edgeTransformer.transform(metadata);
    }

    public E createHyperEdge(HyperEdgeMetadata metadata) {
        return this.hyperEdgeTransformer.transform(metadata);
    }
}

