#!/usr/bin/python

import statistics
import xml.dom.minidom
import sys
import re
from re import split
from math import sqrt
import os

def getText(nodelist):
    rc = []
    for node in nodelist:
        if node.nodeType == node.TEXT_NODE:
            rc.append(node.data)
    return ''.join(rc)

def handleCluster(cluster):
    numberOfVertices = getText(cluster.getElementsByTagName("vertex")[0].childNodes)
    conductance = getText(cluster.getElementsByTagName("conductance")[0].childNodes)
    print numberOfVertices + " " + conductance

def handleClusters(clusters):
    for cluster in clusters.getElementsByTagName("cluster"):
        handleCluster(cluster)

def handleRun(run):
    clusters = run.getElementsByTagName("clusters")[0]
    handleClusters(clusters)

fileXML = sys.argv[1]
dom = xml.dom.minidom.parse(fileXML)
handleRun(dom)








#basedir = sys.argv[1]

#filesList = [basedir + file for file in os.listdir(basedir) if (re.match('.*dat$', file) and not re.match('^output.*', file))]

#results = []
#for file in filesList:
#    inp = open(file,"r")
#    values = []
#    for line in inp.readlines():
#        values.append(float(line))
#    inp.close()
#    print "File ",file," acquisito."
#    results.append(statistics.mean(values))
#variance = statistics.variance(results, mode = "Unbiased")
#confidence = sqrt(variance / len(results)) * 1.6449
#print "Average: ",statistics.mean(results)," Confidence interval: ",confidence
