package weka.clusterers.forMetisMQI.util;

import java.awt.CardLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class GraphsFrame extends JFrame {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private int numberOfPanels = 0;

	private JPanel graphPanel = null;
	private JPanel buttonPanel = null;
	private JButton nextButton = null;
	private JButton prevButton = null;

	public GraphsFrame(String name) {
		super(name);
		setBounds(new Rectangle(800, 700));

		graphPanel = new JPanel();
		graphPanel.setName("graphPanel");
		graphPanel.setBounds(0,40,800, 660);
		graphPanel.setLayout(new CardLayout());
		getContentPane().add(graphPanel);

		buttonPanel = new JPanel();
		nextButton = new JButton(">>");

		nextButton.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				CardLayout c = (CardLayout) graphPanel.getLayout();
				c.next(graphPanel);
			}
		});
		prevButton = new JButton("<<");
		prevButton.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				CardLayout c = (CardLayout) graphPanel.getLayout();
				c.previous(graphPanel);
			}
		});
		buttonPanel.setBounds(0, 0, 800, 40);
		buttonPanel.add(prevButton);
		buttonPanel.add(nextButton);
		getContentPane().add(buttonPanel);
	}

	public void addPanel(JPanel panel) {
		graphPanel.add(panel, Integer.toString(numberOfPanels));
		numberOfPanels++;
	}
}
