package weka.clusterers.forMetisMQI.coarse;

import java.util.Map;

import weka.clusterers.forMetisMQI.graph.Node;
import weka.clusterers.forMetisMQI.graph.UndirectedGraph;

public class CoarserGraphElement {
	
	private UndirectedGraph contracted;
	private UndirectedGraph projected;
	private Map<Node,Node> match;
	private Map<Node,Node> map;
	
	public CoarserGraphElement(UndirectedGraph contracted, UndirectedGraph projected, Map<Node,Node> match, Map<Node,Node> map) {
		this.contracted = contracted;
		this.projected = projected;
		this.match = match;
		this.map = map;
	}
	
	public Map<Node,Node> getMatch() {
		return match;
	}
	
	public Map<Node,Node> getMap() {
		return map;
	}
	
	public UndirectedGraph getContracted() {
		return contracted;
	}
	
	public UndirectedGraph getProjected() {
		return projected;
	}

}
