package weka.clusterers.forMetisMQI;


public class Node {

	private String id;

	/** The weight of the node */
	private int vwgt;
	/** The weight of the edges that have been contracted to create the node */
	private int cewgt;
	public Node(String id) {
		this.id = id;
		this.vwgt = 1;
		this.cewgt = 0;
	}

	@Override
	public boolean equals(Object o) {
		return (o instanceof Node) && (((Node) o).getId().equals(id));
	}

	@Override
	public int hashCode() {
		int hash = 1;
		hash = hash * 31 + id.hashCode();
		return hash;
	}

	public String getId() {
		return id;
	}

	@Override
	public String toString() {
		return "N" + id; //+ " Cewgt: " + cewgt;
	}

	public int getVwgt() {
		return vwgt;
	}

	public void setVwgt(int vwgt) {
		this.vwgt = vwgt;
	}

	public int getCewgt() {
		return cewgt;
	}

	public void setCewgt(int cewgt) {
		this.cewgt = cewgt;
	}

	@Override
	public Node clone() {
		Node n = new Node(id);
		n.cewgt = cewgt;
		n.vwgt = vwgt;
		return n;
	}

}
