/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.layout;

import edu.uci.ics.jung.algorithms.layout.AbstractLayout;
import edu.uci.ics.jung.algorithms.layout.GraphElementAccessor;
import edu.uci.ics.jung.algorithms.layout.RadiusGraphElementAccessor;
import edu.uci.ics.jung.algorithms.layout.util.RandomLocationTransformer;
import edu.uci.ics.jung.algorithms.util.IterativeContext;
import edu.uci.ics.jung.graph.Graph;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections15.Factory;
import org.apache.commons.collections15.map.LazyMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ISOMLayout<V, E>
extends AbstractLayout<V, E>
implements IterativeContext {
    Map<V, ISOMVertexData> isomVertexData = LazyMap.decorate(new HashMap(), new Factory<ISOMVertexData>(){

        @Override
        public ISOMVertexData create() {
            return new ISOMVertexData();
        }
    });
    private int maxEpoch;
    private int epoch;
    private int radiusConstantTime;
    private int radius;
    private int minRadius;
    private double adaption;
    private double initialAdaption;
    private double minAdaption;
    protected GraphElementAccessor<V, E> elementAccessor = new RadiusGraphElementAccessor();
    private double coolingFactor;
    private List<V> queue = new ArrayList<V>();
    private String status = null;

    public String getStatus() {
        return this.status;
    }

    public ISOMLayout(Graph<V, E> g) {
        super(g);
    }

    @Override
    public void initialize() {
        this.setInitializer(new RandomLocationTransformer(this.getSize()));
        this.maxEpoch = 2000;
        this.epoch = 1;
        this.radiusConstantTime = 100;
        this.radius = 5;
        this.minRadius = 1;
        this.adaption = this.initialAdaption = 0.9;
        this.minAdaption = 0.0;
        this.coolingFactor = 2.0;
    }

    @Override
    public void step() {
        this.status = "epoch: " + this.epoch + "; ";
        if (this.epoch < this.maxEpoch) {
            this.adjust();
            this.updateParameters();
            this.status = this.status + " status: running";
        } else {
            this.status = this.status + "adaption: " + this.adaption + "; ";
            this.status = this.status + "status: done";
        }
    }

    private synchronized void adjust() {
        Point2D.Double tempXYD = new Point2D.Double();
        ((Point2D)tempXYD).setLocation(10.0 + Math.random() * this.getSize().getWidth(), 10.0 + Math.random() * this.getSize().getHeight());
        V winner = this.elementAccessor.getVertex(this, ((Point2D)tempXYD).getX(), ((Point2D)tempXYD).getY());
        while (true) {
            try {
                for (Object v : this.getGraph().getVertices()) {
                    ISOMVertexData ivd = this.getISOMVertexData(v);
                    ivd.distance = 0;
                    ivd.visited = false;
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                continue;
            }
            break;
        }
        this.adjustVertex(winner, tempXYD);
    }

    private synchronized void updateParameters() {
        ++this.epoch;
        double factor = Math.exp(-1.0 * this.coolingFactor * (1.0 * (double)this.epoch / (double)this.maxEpoch));
        this.adaption = Math.max(this.minAdaption, factor * this.initialAdaption);
        if (this.radius > this.minRadius && this.epoch % this.radiusConstantTime == 0) {
            --this.radius;
        }
    }

    private synchronized void adjustVertex(V v, Point2D tempXYD) {
        this.queue.clear();
        ISOMVertexData ivd = this.getISOMVertexData(v);
        ivd.distance = 0;
        ivd.visited = true;
        this.queue.add(v);
        block2: while (!this.queue.isEmpty()) {
            V current = this.queue.remove(0);
            ISOMVertexData currData = this.getISOMVertexData(current);
            Object currXYData = this.transform((Object)current);
            double dx = tempXYD.getX() - ((Point2D)currXYData).getX();
            double dy = tempXYD.getY() - ((Point2D)currXYData).getY();
            double factor = this.adaption / Math.pow(2.0, currData.distance);
            ((Point2D)currXYData).setLocation(((Point2D)currXYData).getX() + factor * dx, ((Point2D)currXYData).getY() + factor * dy);
            if (currData.distance >= this.radius) continue;
            Collection<V> s = this.getGraph().getNeighbors(current);
            while (true) {
                try {
                    for (V child : s) {
                        ISOMVertexData childData = this.getISOMVertexData(child);
                        if (childData == null || childData.visited) continue;
                        childData.visited = true;
                        childData.distance = currData.distance + 1;
                        this.queue.add(child);
                    }
                    continue block2;
                }
                catch (ConcurrentModificationException cme) {
                    continue;
                }
                break;
            }
        }
    }

    protected ISOMVertexData getISOMVertexData(V v) {
        return this.isomVertexData.get(v);
    }

    public boolean isIncremental() {
        return true;
    }

    @Override
    public boolean done() {
        return this.epoch >= this.maxEpoch;
    }

    @Override
    public void reset() {
        this.epoch = 0;
    }

    protected static class ISOMVertexData {
        int distance = 0;
        boolean visited = false;

        protected ISOMVertexData() {
        }
    }
}

