
package data;

import GraphType.DirectedDenseGraph;
import clustering.Edge;
import edu.uci.ics.jung.graph.DirectedSparseGraph;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.SparseGraph;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;


public class GraphBuilder {

    Graph<String,Integer> graph;

    public GraphBuilder(boolean directed){
        if (directed)
            graph = new DirectedDenseGraph<String, Integer>();
           //graph = new DirectedSparseGraph<String, Integer>();

        else
            graph = new SparseGraph<String, Integer>();
    }

    public Graph<String, Integer> getGraph() {
        return graph;
    }

    public void buildGraphFromCVS(String path, int maxreadline){
        try {
            FileInputStream fstream = new FileInputStream(path);
            DataInputStream in = new DataInputStream(fstream);
            BufferedReader br = new BufferedReader(new InputStreamReader(in));

            String read;
            int edge=0;
            String[] splitted;
            while((read = br.readLine()) != null){
                if(!read.trim().isEmpty()){
                    splitted = read.trim().split(",");
                    graph.addEdge(edge, splitted[0], splitted[1]);
                    edge++;
                }
            }
            br.close();
            in.close();
            fstream.close();

        } catch (FileNotFoundException e) {
            System.out.println("<GraphBuilder> Error: file not found!");
        } catch(IOException e){
            System.out.println("<GraphBuilder> Error: closing FileInputStream");
        }
    }

}
