
package data;

import clustering.Edge;
import clustering.VertexString;
import edu.uci.ics.jung.graph.DirectedSparseGraph;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.SparseGraph;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;


public class GraphBuilder {

    Graph<String,Edge<String>> graph;

    public GraphBuilder(boolean directed){
        if (directed)
           graph = new DirectedSparseGraph<String, Edge<String>>();

        else
            graph = new SparseGraph<String, Edge<String>>();
    }

    public Graph<String, Edge<String>> getGraph() {
        return graph;
    }

    public void buildGraphFromARFF(String path, int maxreadline){
        try {
            FileInputStream fstream = new FileInputStream(path);
            DataInputStream in = new DataInputStream(fstream);
            BufferedReader br = new BufferedReader(new InputStreamReader(in));

            Set<String> vertex = new HashSet<String>();

            String read;
            int edge=0;
            int count=0;
            while(((read = br.readLine()) != null) && (count < maxreadline)){
                count++;
                if(!(read.contains("@DATA") || read.contains("@RELATION") || read.contains("@ATTRIBUTE") || read.trim().isEmpty())){
                    String[] splitted = read.trim().split(",");
                    vertex.addAll(Arrays.asList(splitted));
                    graph.addEdge(new Edge<String>(splitted[0], splitted[1]), splitted[0], splitted[1]);
                    edge++;
                }
            }
            br.close();
            in.close();
            fstream.close();

        } catch (FileNotFoundException e) {
            System.out.println("<GraphBuilder> Error: file not found!");
        } catch(IOException e){
            System.out.println("<GraphBuilder> Error: closing FileInputStream");
        }
    }

}
