/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections15.functors;

import java.io.Serializable;
import org.apache.commons.collections15.Closure;
import org.apache.commons.collections15.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClosureTransformer<T>
implements Transformer<T, T>,
Serializable {
    static final long serialVersionUID = 478466901448617286L;
    private final Closure<T> iClosure;

    public static <T> Transformer<T, T> getInstance(Closure<T> closure) {
        if (closure == null) {
            throw new IllegalArgumentException("Closure must not be null");
        }
        return new ClosureTransformer<T>(closure);
    }

    public ClosureTransformer(Closure<T> closure) {
        this.iClosure = closure;
    }

    @Override
    public T transform(T input) {
        this.iClosure.execute(input);
        return input;
    }

    public Closure<T> getClosure() {
        return this.iClosure;
    }
}

