
package view;

import clustering.VertexScore;
import clustering.VertexString;
import edu.uci.ics.jung.algorithms.layout.DAGLayout;
import edu.uci.ics.jung.algorithms.layout.FRLayout;
import edu.uci.ics.jung.algorithms.layout.KKLayout;
import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.visualization.BasicVisualizationServer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.xml.bind.JAXB;
import org.apache.commons.collections15.Transformer;



public class Viewer<V,E> {

    Graph<V,E> graph;
    Layout<V, E> layout;
    BasicVisualizationServer<V,E> vv;
    JFrame frame;
    JButton button;
    JPanel button_panel;
    JTextArea text ;

    public Viewer(Graph<V,E> graph, ActionListener listerner) {
        this.button = new JButton("Next");
        this.button.addActionListener(listerner);
        this.button_panel = new JPanel(new BorderLayout(100,100));
        this.button_panel.add(button);
        this.text = new JTextArea();
        this.text.setEditable(false);
        this.text.setBackground(Color.yellow);

        this.graph = graph;
        this.frame = new JFrame("Clustering with Google PageRank");
        this.frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        KKLayout kklayout = new KKLayout(graph);
        kklayout.setAdjustForGravity(false);
        kklayout.setMaxIterations(100);
        this.layout = kklayout;
        layout.setSize(new Dimension(1280,700));
        vv = new BasicVisualizationServer(layout);
        vv.setPreferredSize(new Dimension(1280,700));
        vv.add(this.button_panel);
        vv.add(this.text);
        vv.getRenderContext().setVertexLabelTransformer(new VertexLabelTransformer<V, String>());
       
    }

    public void setText(String text){
        this.text.setText(text);
    }
    public void setGraph(Graph<V, E> graph) {
        this.graph = graph;
        layout.setGraph(graph);
        frame.repaint();
    }
    
    public void viewGraphRank(List<VertexScore<V>> pagerank, V seed_node){
         VertexPaintRankTransformer vertexPaint = new VertexPaintRankTransformer(pagerank,seed_node);
         vv.getRenderContext().setVertexFillPaintTransformer((Transformer<V, Paint>) vertexPaint);
         
         frame.getContentPane().add(vv);
         frame.pack();
         frame.repaint();
         frame.setVisible(true);
    }


    public void viewGraph(List<V> cut){
        
         if(cut != null){
             VertexPaintTransformer<V,Paint> vertexPaint = new VertexPaintTransformer<V, Paint>(cut);
             vv.getRenderContext().setVertexFillPaintTransformer(vertexPaint);
         }
         
         frame.getContentPane().add(vv);
         frame.pack();
         frame.repaint();
         frame.setVisible(true);

     }

}
