/*
 * Decompiled with CFR 0.152.
 */
package data;

import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.SparseGraph;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphBuilder {
    Graph<String, Integer> graph = new SparseGraph();

    public Graph<String, Integer> getGraph() {
        return this.graph;
    }

    public void buildGraphFromARFF(String path, int maxreadline) {
        try {
            String read;
            FileInputStream fstream = new FileInputStream(path);
            DataInputStream in = new DataInputStream(fstream);
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            HashSet<String> vertex = new HashSet<String>();
            int edge = 0;
            for (int count = 0; (read = br.readLine()) != null && count < maxreadline; ++count) {
                if (read.contains("@DATA") || read.contains("@RELATION") || read.contains("@ATTRIBUTE") || read.trim().isEmpty()) continue;
                String[] splitted = read.trim().split(",");
                vertex.addAll(Arrays.asList(splitted));
                this.graph.addEdge((Object)edge, (Object)splitted[0], (Object)splitted[1]);
                ++edge;
            }
            br.close();
            in.close();
            fstream.close();
        }
        catch (FileNotFoundException e) {
            System.out.println("<GraphBuilder> Error: file not found!");
        }
        catch (IOException e) {
            System.out.println("<GraphBuilder> Error: closing FileInputStream");
        }
    }
}

