
package data;

import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.SparseGraph;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;


public class GraphBuilder<V,E> {

    Graph<String,Integer> graph;

    public GraphBuilder(){
        graph = new SparseGraph<String, Integer>();

    }

    public Graph<String, Integer> getGraph() {
        return graph;
    }

    public void buildGraphFromARFF(String path, int maxreadline){
        try {
            FileInputStream fstream = new FileInputStream(path);
            DataInputStream in = new DataInputStream(fstream);
            BufferedReader br = new BufferedReader(new InputStreamReader(in));

            Set<String> vertex = new HashSet<String>();

            String read;
            int edge=0;
            int count=0;
            while(((read = br.readLine()) != null) && (count < maxreadline)){
                count++;
                if(!(read.contains("@DATA") || read.contains("@RELATION") || read.contains("@ATTRIBUTE") || read.trim().isEmpty())){
                    String[] splitted = read.trim().split(",");
                    vertex.addAll(Arrays.asList(splitted));
                    graph.addEdge(edge, splitted[0], splitted[1]);
                    edge++;
                }
            }
            br.close();
            in.close();
            fstream.close();

        } catch (FileNotFoundException e) {
            System.out.println("<GraphBuilder> Error: file not found!");
        } catch(IOException e){
            System.out.println("<GraphBuilder> Error: closing FileInputStream");
        }
    }

}
