
package view;

import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.util.Pair;
import java.io.File;
import java.util.Collection;
import java.util.List;

public class GraphToGraphviz<V,E> {

    GraphViz gv;

    public GraphToGraphviz(){
        gv = new GraphViz();
    }

    public void renderGraph(Graph<V,E> graph){
        Collection<E> edges = graph.getEdges();
        gv.addln(gv.start_graph());
        for (E edge : edges){
            Pair<V> nodes = graph.getEndpoints(edge);
            gv.addln(nodes.getFirst().toString() + " -> " + nodes.getSecond().toString());
        }
        gv.addln(gv.end_graph());
        File out = new File("/home/luke/Desktop/out.gif");
        gv.writeGraphToFile(gv.getGraph(gv.getDotSource()), out);
    }
}
