
package view;

import clustering.VertexScore;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections15.Transformer;


public class VertexPaintRankTransformer<V,Paint> implements Transformer<V,Paint>{

    List<VertexScore<V>> pagerank;
    List<V> cluster;

    public VertexPaintRankTransformer(List<VertexScore<V>> ranking, List<V> cluster){
        this.pagerank = ranking;
        this.cluster = cluster;
    }

    public Paint transform(V node) {

        if(cluster != null){
            if (cluster.contains(node)){
                return (Paint) Color.GREEN;
            }
        }
        double score = 0;
        for(VertexScore s : pagerank){
            if(s.getVertex().equals(node))
                score = s.getScore();
        }
        int rgb = (int)((255 * score) / pagerank.get(0).getScore());
        return (Paint) new Color(rgb,0,0);
     }


}
