/*
 * Decompiled with CFR 0.152.
 */
package view;

import clustering.VertexScore;
import java.awt.Color;
import java.util.List;
import org.apache.commons.collections15.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VertexPaintRankTransformer<V, Paint>
implements Transformer<V, Paint> {
    List<VertexScore<V>> pagerank;
    List<V> cluster;

    public VertexPaintRankTransformer(List<VertexScore<V>> ranking, List<V> cluster) {
        this.pagerank = ranking;
        this.cluster = cluster;
    }

    @Override
    public Paint transform(V node) {
        if (this.cluster != null && this.cluster.contains(node)) {
            return (Paint)Color.GREEN;
        }
        double score = 0.0;
        for (VertexScore<V> s : this.pagerank) {
            if (!s.getVertex().equals(node)) continue;
            score = s.getScore();
        }
        int rgb = (int)(255.0 * score / this.pagerank.get(0).getScore());
        return (Paint)new Color(rgb, 0, 0);
    }
}

