/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections15.functors;

import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.collections15.Closure;
import org.apache.commons.collections15.Predicate;
import org.apache.commons.collections15.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FunctorUtils {
    private FunctorUtils() {
    }

    static <T> Predicate<? super T>[] copy(Predicate<? super T>[] predicates) {
        if (predicates == null) {
            return null;
        }
        return (Predicate[])predicates.clone();
    }

    static <T> void validate(Predicate<? super T>[] predicates) {
        if (predicates == null) {
            throw new IllegalArgumentException("The predicate array must not be null");
        }
        for (int i = 0; i < predicates.length; ++i) {
            if (predicates[i] != null) continue;
            throw new IllegalArgumentException("The predicate array must not contain a null predicate, index " + i + " was null");
        }
    }

    static <T> void validateMin2(Predicate<? super T>[] predicates) {
        if (predicates == null) {
            throw new IllegalArgumentException("The predicate array must not be null");
        }
        if (predicates.length < 2) {
            throw new IllegalArgumentException("At least 2 predicates must be specified in the predicate array, size was " + predicates.length);
        }
        for (int i = 0; i < predicates.length; ++i) {
            if (predicates[i] != null) continue;
            throw new IllegalArgumentException("The predicate array must not contain a null predicate, index " + i + " was null");
        }
    }

    static <T> Predicate<? super T>[] validate(Collection<Predicate<? super T>> predicates) {
        if (predicates == null) {
            throw new IllegalArgumentException("The predicate collection must not be null");
        }
        if (predicates.size() < 2) {
            throw new IllegalArgumentException("At least 2 predicates must be specified in the predicate collection, size was " + predicates.size());
        }
        Predicate[] preds = new Predicate[predicates.size()];
        int i = 0;
        Iterator<Predicate<T>> it = predicates.iterator();
        while (it.hasNext()) {
            preds[i] = it.next();
            if (preds[i] == null) {
                throw new IllegalArgumentException("The predicate collection must not contain a null predicate, index " + i + " was null");
            }
            ++i;
        }
        return preds;
    }

    static <T> Closure<? super T>[] copy(Closure<? super T>[] closures) {
        if (closures == null) {
            return null;
        }
        return (Closure[])closures.clone();
    }

    static <T> void validate(Closure<? super T>[] closures) {
        if (closures == null) {
            throw new IllegalArgumentException("The closure array must not be null");
        }
        for (int i = 0; i < closures.length; ++i) {
            if (closures[i] != null) continue;
            throw new IllegalArgumentException("The closure array must not contain a null closure, index " + i + " was null");
        }
    }

    static <I, O> Transformer<? super I, ? extends O>[] copy(Transformer<? super I, ? extends O>[] transformers) {
        if (transformers == null) {
            return null;
        }
        return (Transformer[])transformers.clone();
    }

    static <I, O> void validate(Transformer<? super I, ? extends O>[] transformers) {
        if (transformers == null) {
            throw new IllegalArgumentException("The transformer array must not be null");
        }
        for (int i = 0; i < transformers.length; ++i) {
            if (transformers[i] != null) continue;
            throw new IllegalArgumentException("The transformer array must not contain a null transformer, index " + i + " was null");
        }
    }
}

