/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.util;

import edu.uci.ics.jung.algorithms.util.IterativeContext;

public class Animator
implements Runnable {
    protected IterativeContext process;
    protected boolean stop;
    protected Thread thread;
    protected long sleepTime = 10L;

    public Animator(IterativeContext process) {
        this(process, 10L);
    }

    public Animator(IterativeContext process, long sleepTime) {
        this.process = process;
        this.sleepTime = sleepTime;
    }

    public long getSleepTime() {
        return this.sleepTime;
    }

    public void setSleepTime(long sleepTime) {
        this.sleepTime = sleepTime;
    }

    public void start() {
        this.stop();
        this.stop = false;
        this.thread = new Thread(this);
        this.thread.setPriority(1);
        this.thread.start();
    }

    public synchronized void stop() {
        this.stop = true;
    }

    public void run() {
        while (!this.process.done() && !this.stop) {
            this.process.step();
            if (this.stop) {
                return;
            }
            try {
                Thread.sleep(this.sleepTime);
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

