/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.transform;

import edu.uci.ics.jung.algorithms.layout.PolarPoint;
import edu.uci.ics.jung.visualization.transform.LensTransformer;
import edu.uci.ics.jung.visualization.transform.MutableAffineTransformer;
import edu.uci.ics.jung.visualization.transform.MutableTransformer;
import java.awt.Component;
import java.awt.geom.Point2D;

public class HyperbolicTransformer
extends LensTransformer
implements MutableTransformer {
    public HyperbolicTransformer(Component component) {
        this(component, new MutableAffineTransformer());
    }

    public HyperbolicTransformer(Component component, MutableTransformer delegate) {
        super(component, delegate);
    }

    public Point2D transform(Point2D graphPoint) {
        if (graphPoint == null) {
            return null;
        }
        Point2D viewCenter = this.getViewCenter();
        double viewRadius = this.getViewRadius();
        double ratio = this.getRatio();
        Point2D viewPoint = this.delegate.transform(graphPoint);
        double dx = viewPoint.getX() - viewCenter.getX();
        double dy = viewPoint.getY() - viewCenter.getY();
        Point2D.Double pointFromCenter = new Point2D.Double(dx *= ratio, dy);
        PolarPoint polar = PolarPoint.cartesianToPolar((Point2D)pointFromCenter);
        double theta = polar.getTheta();
        double radius = polar.getRadius();
        if (radius > viewRadius) {
            return viewPoint;
        }
        double mag = Math.tan(1.5707963267948966 * (double)this.magnification);
        radius *= mag;
        radius = Math.min(radius, viewRadius);
        radius /= viewRadius;
        radius *= 1.5707963267948966;
        radius = Math.abs(Math.atan(radius));
        Point2D projectedPoint = PolarPoint.polarToCartesian((double)theta, (double)(radius *= viewRadius));
        projectedPoint.setLocation(projectedPoint.getX() / ratio, projectedPoint.getY());
        Point2D.Double translatedBack = new Point2D.Double(projectedPoint.getX() + viewCenter.getX(), projectedPoint.getY() + viewCenter.getY());
        return translatedBack;
    }

    public Point2D inverseTransform(Point2D viewPoint) {
        Point2D viewCenter = this.getViewCenter();
        double viewRadius = this.getViewRadius();
        double ratio = this.getRatio();
        double dx = viewPoint.getX() - viewCenter.getX();
        double dy = viewPoint.getY() - viewCenter.getY();
        Point2D.Double pointFromCenter = new Point2D.Double(dx *= ratio, dy);
        PolarPoint polar = PolarPoint.cartesianToPolar((Point2D)pointFromCenter);
        double radius = polar.getRadius();
        if (radius > viewRadius) {
            return this.delegate.inverseTransform(viewPoint);
        }
        radius /= viewRadius;
        radius = Math.abs(Math.tan(radius));
        radius /= 1.5707963267948966;
        radius *= viewRadius;
        double mag = Math.tan(1.5707963267948966 * (double)this.magnification);
        polar.setRadius(radius /= mag);
        Point2D projectedPoint = PolarPoint.polarToCartesian((PolarPoint)polar);
        projectedPoint.setLocation(projectedPoint.getX() / ratio, projectedPoint.getY());
        Point2D.Double translatedBack = new Point2D.Double(projectedPoint.getX() + viewCenter.getX(), projectedPoint.getY() + viewCenter.getY());
        return this.delegate.inverseTransform(translatedBack);
    }
}

