/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.importance;

import edu.uci.ics.jung.algorithms.importance.RandomWalkSTBetweenness;
import edu.uci.ics.jung.graph.UndirectedGraph;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RandomWalkBetweenness<V, E>
extends RandomWalkSTBetweenness<V, E> {
    public static final String CENTRALITY = "centrality.RandomWalkBetweennessCentrality";

    public RandomWalkBetweenness(UndirectedGraph<V, E> g) {
        super(g, null, null);
    }

    @Override
    protected void computeBetweenness() {
        this.setUp();
        int numVertices = this.getGraph().getVertexCount();
        double normalizingConstant = (double)(numVertices * (numVertices - 1)) / 2.0;
        for (Object ithVertex : this.getGraph().getVertices()) {
            double ithBetweenness = 0.0;
            for (int t = 0; t < numVertices; ++t) {
                for (int s = 0; s < t; ++s) {
                    Object sthVertex = this.getIndexer().getKey(s);
                    Object tthVertex = this.getIndexer().getKey(t);
                    ithBetweenness += this.computeSTBetweenness(ithVertex, sthVertex, tthVertex);
                }
            }
            this.setVertexRankScore(ithVertex, ithBetweenness / normalizingConstant);
        }
    }

    @Override
    public String getRankScoreKey() {
        return CENTRALITY;
    }

    protected double evaluateIteration() {
        this.computeBetweenness();
        return 0.0;
    }
}

