/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization3d;

import com.sun.j3d.utils.behaviors.mouse.MouseWheelZoom;
import com.sun.j3d.utils.geometry.Primitive;
import com.sun.j3d.utils.picking.behaviors.PickingCallback;
import com.sun.j3d.utils.universe.SimpleUniverse;
import edu.uci.ics.jung.algorithms.layout.util.VisRunner;
import edu.uci.ics.jung.algorithms.layout3d.Layout;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.util.Context;
import edu.uci.ics.jung.graph.util.Pair;
import edu.uci.ics.jung.visualization.picking.MultiPickedState;
import edu.uci.ics.jung.visualization.picking.PickedState;
import edu.uci.ics.jung.visualization3d.EdgeGroup;
import edu.uci.ics.jung.visualization3d.PickVertexBehavior;
import edu.uci.ics.jung.visualization3d.PluggableRenderContext;
import edu.uci.ics.jung.visualization3d.RenderContext;
import edu.uci.ics.jung.visualization3d.VertexGroup;
import edu.uci.ics.jung.visualization3d.control.MouseRotate;
import edu.uci.ics.jung.visualization3d.control.MouseTranslate;
import edu.uci.ics.jung.visualization3d.control.PickSphereBehavior;
import edu.uci.ics.jung.visualization3d.control.PickTranslateBehavior;
import edu.uci.ics.jung.visualization3d.layout.LayoutEventBroadcaster;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GraphicsConfiguration;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.Map;
import javax.media.j3d.AmbientLight;
import javax.media.j3d.Appearance;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.Font3D;
import javax.media.j3d.FontExtrusion;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.OrientedShape3D;
import javax.media.j3d.Text3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.apache.commons.collections15.BidiMap;
import org.apache.commons.collections15.bidimap.DualHashBidiMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VisualizationViewer<V, E>
extends JPanel {
    BranchGroup objRoot;
    TransformGroup objTrans;
    Appearance grayLook;
    protected ItemListener pickEventListener;
    protected PickedState<V> pickedVertexState;
    protected PickedState<E> pickedEdgeState;
    protected RenderContext<V, E> renderContext = new PluggableRenderContext();
    BidiMap<V, VertexGroup> vertexMap = new DualHashBidiMap();
    Map<E, EdgeGroup> edgeMap = new HashMap<E, EdgeGroup>();
    Graph<V, E> graph;
    Layout<V, E> layout;

    public VisualizationViewer() {
        this.setLayout(new BorderLayout());
        this.renderContext.setPickedVertexState((PickedState<V>)new MultiPickedState());
        this.renderContext.setPickedEdgeState((PickedState<E>)new MultiPickedState());
        GraphicsConfiguration config = SimpleUniverse.getPreferredConfiguration();
        Canvas3D c = new Canvas3D(config);
        this.add((Component)c, "Center");
        this.setPickedVertexState((PickedState<V>)new MultiPickedState());
        this.setPickedEdgeState((PickedState<E>)new MultiPickedState());
        BranchGroup scene = this.createSceneGraph(c);
        SimpleUniverse u = new SimpleUniverse(c);
        u.getViewer().getView().setUserHeadToVworldEnable(true);
        u.getViewingPlatform().setNominalViewingTransform();
        u.addBranchGraph(scene);
    }

    public Layout<V, E> getGraphLayout() {
        return this.layout;
    }

    public BranchGroup createSceneGraph(Canvas3D canvas) {
        this.objRoot = new BranchGroup();
        this.objRoot.setCapability(14);
        this.objRoot.setCapability(13);
        TransformGroup objScale = new TransformGroup();
        Transform3D t3d = new Transform3D();
        objScale.setTransform(t3d);
        this.objRoot.addChild(objScale);
        Transform3D tt = new Transform3D();
        tt.setScale(0.05);
        tt.setTranslation(new Vector3f(0.0f, 0.0f, -30.0f));
        this.objTrans = new TransformGroup(tt);
        this.objTrans.setCapability(18);
        this.objTrans.setCapability(17);
        this.objTrans.setCapability(14);
        objScale.addChild(this.objTrans);
        Appearance look = new Appearance();
        Color3f objColor = new Color3f(0.7f, 0.7f, 0.7f);
        Color3f black = new Color3f(0.0f, 0.0f, 0.0f);
        Color3f white = new Color3f(1.0f, 1.0f, 0.6f);
        Color3f gray = new Color3f(0.2f, 0.2f, 0.2f);
        Color3f red = new Color3f(1.0f, 0.0f, 0.0f);
        Color3f yellow = new Color3f(1.0f, 1.0f, 0.0f);
        Material objMaterial = new Material(objColor, black, objColor, white, 100.0f);
        Material blackMaterial = new Material(objColor, black, black, objColor, 10.0f);
        Material whiteMaterial = new Material(white, white, white, white, 100.0f);
        Material grayMaterial = new Material(gray, black, gray, gray, 100.0f);
        Material redMaterial = new Material(red, black, red, red, 100.0f);
        Material yellowMaterial = new Material(yellow, black, yellow, yellow, 100.0f);
        look.setMaterial(new Material(objColor, black, objColor, white, 100.0f));
        Appearance blackLook = new Appearance();
        blackLook.setMaterial(blackMaterial);
        Appearance whiteLook = new Appearance();
        whiteLook.setMaterial(whiteMaterial);
        Appearance grayLook = new Appearance();
        grayLook.setMaterial(grayMaterial);
        grayLook.setCapability(0);
        grayLook.setCapability(1);
        final Appearance redLook = new Appearance();
        redLook.setMaterial(redMaterial);
        Appearance objLook = new Appearance();
        objLook.setMaterial(objMaterial);
        grayLook = objLook;
        final Appearance yellowLook = new Appearance();
        yellowLook.setMaterial(yellowMaterial);
        BoundingSphere bounds = new BoundingSphere(new Point3d(), 300.0);
        MouseRotate behavior1 = new MouseRotate();
        behavior1.setTransformGroup(this.objTrans);
        this.objTrans.addChild((Node)((Object)behavior1));
        behavior1.setSchedulingBounds(bounds);
        MouseWheelZoom behavior2 = new MouseWheelZoom();
        behavior2.setTransformGroup(this.objTrans);
        this.objTrans.addChild((Node)behavior2);
        behavior2.setSchedulingBounds((Bounds)bounds);
        MouseTranslate behavior3 = new MouseTranslate();
        behavior3.setTransformGroup(this.objTrans);
        this.objTrans.addChild((Node)((Object)behavior3));
        behavior3.setSchedulingBounds(bounds);
        PickTranslateBehavior ptb = new PickTranslateBehavior(this.objRoot, canvas, bounds, 256);
        ptb.setSchedulingBounds(bounds);
        ptb.setupCallback(new PickingCallback(){

            public void transformChanged(int type, TransformGroup tg) {
                if (tg == null) {
                    return;
                }
                Transform3D t3d = new Transform3D();
                tg.getTransform(t3d);
                Point3f p1 = new Point3f();
                Object v = VisualizationViewer.this.vertexMap.getKey((Object)tg);
                Point3f p0 = (Point3f)VisualizationViewer.this.layout.transform(v);
                t3d.transform(p1);
                System.err.println("change location for vertex " + v + ", transformGroup " + tg + " from " + p0 + " to " + p1);
            }
        });
        PickSphereBehavior psb = new PickSphereBehavior(this.objRoot, canvas, (Bounds)bounds);
        PickVertexBehavior pvb = new PickVertexBehavior(this.objRoot, canvas, bounds, this.renderContext.getPickedVertexState());
        this.objTrans.addChild((Node)((Object)pvb));
        pvb.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                for (Object v : VisualizationViewer.this.graph.getVertices()) {
                    Node node;
                    VertexGroup vg = (VertexGroup)VisualizationViewer.this.vertexMap.get(v);
                    Appearance look = redLook;
                    if (VisualizationViewer.this.renderContext.getPickedVertexState().isPicked(v)) {
                        look = yellowLook;
                    }
                    if (!((node = vg.getShape()) instanceof Primitive)) continue;
                    ((Primitive)node).setAppearance(look);
                }
            }
        });
        Color3f lColor1 = new Color3f(0.5f, 0.5f, 0.5f);
        Color3f lColor2 = new Color3f(1.0f, 1.0f, 1.0f);
        Vector3f lDir2 = new Vector3f(-1.0f, 0.0f, -1.0f);
        DirectionalLight lgt2 = new DirectionalLight(lColor2, lDir2);
        AmbientLight ambient = new AmbientLight(lColor1);
        lgt2.setInfluencingBounds(bounds);
        ambient.setInfluencingBounds(bounds);
        this.objRoot.addChild(lgt2);
        this.objRoot.addChild(ambient);
        this.objRoot.compile();
        return this.objRoot;
    }

    public void setGraphLayout(Layout<V, E> inLayout) {
        this.graph = inLayout.getGraph();
        BranchGroup branch = new BranchGroup();
        LayoutEventBroadcaster<V, E> elayout = new LayoutEventBroadcaster<V, E>(inLayout);
        this.layout = elayout;
        for (Object v : this.graph.getVertices()) {
            VertexGroup vg = new VertexGroup(v, (Node)this.renderContext.getVertexShapeTransformer().transform(v));
            vg.setCapability(18);
            vg.setCapability(17);
            this.vertexMap.put(v, vg);
            branch.addChild(vg);
            String label = (String)this.renderContext.getVertexStringer().transform(v);
            if (label == null) continue;
            String fontName = "Serif";
            Font3D f3d = new Font3D(new Font(fontName, 0, 2), new FontExtrusion());
            Text3D txt = new Text3D(f3d, label, new Point3f(2.0f, 2.0f, 0.0f));
            OrientedShape3D textShape = new OrientedShape3D();
            textShape.setGeometry(txt);
            textShape.setAppearance(this.grayLook);
            textShape.setAlignmentMode(1);
            textShape.setRotationPoint(new Point3f());
            Transform3D tt = new Transform3D();
            tt.setScale(5.0);
            TransformGroup tg = new TransformGroup(tt);
            tg.addChild(textShape);
            BranchGroup bg = new BranchGroup();
            bg.addChild(tg);
            vg.getLabelNode().addChild(bg);
        }
        System.err.println("vertexMap = " + this.vertexMap);
        for (Object edge : this.graph.getEdges()) {
            EdgeGroup eg = new EdgeGroup(edge, (Node)this.renderContext.getEdgeShapeTransformer().transform((Object)Context.getInstance(this.graph, edge)));
            eg.setCapability(18);
            eg.setCapability(17);
            this.edgeMap.put(edge, eg);
            branch.addChild(eg);
        }
        this.objTrans.addChild(branch);
        elayout.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                for (Object v : VisualizationViewer.this.vertexMap.keySet()) {
                    Point3f p = (Point3f)VisualizationViewer.this.layout.transform(v);
                    Vector3f pv = new Vector3f(p.getX(), p.getY(), p.getZ());
                    Transform3D tx = new Transform3D();
                    tx.setTranslation(pv);
                    ((VertexGroup)VisualizationViewer.this.vertexMap.get(v)).setTransform(tx);
                }
                for (Object edge : VisualizationViewer.this.graph.getEdges()) {
                    Pair endpoints = VisualizationViewer.this.graph.getEndpoints(edge);
                    Object start = endpoints.getFirst();
                    Object end = endpoints.getSecond();
                    EdgeGroup eg = VisualizationViewer.this.edgeMap.get(edge);
                    eg.setEndpoints((Point3f)VisualizationViewer.this.layout.transform(start), (Point3f)VisualizationViewer.this.layout.transform(end));
                }
            }
        });
        elayout.setSize(new BoundingSphere(new Point3d(), 200.0));
        elayout.initialize();
        VisRunner runner = new VisRunner(elayout);
        runner.relax();
    }

    public void setPickedVertexState(PickedState<V> pickedVertexState) {
        if (this.pickEventListener != null && this.pickedVertexState != null) {
            this.pickedVertexState.removeItemListener(this.pickEventListener);
        }
        this.pickedVertexState = pickedVertexState;
        this.renderContext.setPickedVertexState(pickedVertexState);
        if (this.pickEventListener == null) {
            this.pickEventListener = new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    System.err.println(e.getItem() + " was picked");
                }
            };
        }
        pickedVertexState.addItemListener(this.pickEventListener);
    }

    public void setPickedEdgeState(PickedState<E> pickedEdgeState) {
        if (this.pickEventListener != null && this.pickedEdgeState != null) {
            this.pickedEdgeState.removeItemListener(this.pickEventListener);
        }
        this.pickedEdgeState = pickedEdgeState;
        this.renderContext.setPickedEdgeState(pickedEdgeState);
        if (this.pickEventListener == null) {
            this.pickEventListener = new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    VisualizationViewer.this.repaint();
                }
            };
        }
        pickedEdgeState.addItemListener(this.pickEventListener);
    }

    public RenderContext<V, E> getRenderContext() {
        return this.renderContext;
    }
}

