/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.io;

import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.SparseDoubleMatrix2D;
import edu.uci.ics.jung.algorithms.matrix.GraphMatrixOperations;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.io.GraphFile;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.collections15.Factory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatrixFile<V, E>
implements GraphFile<V, E> {
    private Map<E, Number> mWeightKey;
    Factory<? extends Graph<V, E>> graphFactory;
    Factory<V> vertexFactory;
    Factory<E> edgeFactory;

    public MatrixFile(Map<E, Number> weightKey, Factory<? extends Graph<V, E>> graphFactory, Factory<V> vertexFactory, Factory<E> edgeFactory) {
        this.mWeightKey = weightKey;
        this.graphFactory = graphFactory;
        this.vertexFactory = vertexFactory;
        this.edgeFactory = edgeFactory;
    }

    public Graph<V, E> load(BufferedReader reader) throws IOException {
        Graph graph = null;
        DoubleMatrix2D matrix = this.createMatrixFromFile(reader);
        graph = GraphMatrixOperations.matrixToGraph((DoubleMatrix2D)matrix, this.graphFactory, this.vertexFactory, this.edgeFactory);
        return graph;
    }

    private DoubleMatrix2D createMatrixFromFile(BufferedReader reader) throws IOException {
        StringTokenizer tokenizer;
        ArrayList rows = new ArrayList();
        String currentLine = null;
        while ((currentLine = reader.readLine()) != null && (tokenizer = new StringTokenizer(currentLine)).countTokens() != 0) {
            ArrayList<Double> currentRow = new ArrayList<Double>();
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                currentRow.add(Double.parseDouble(token));
            }
            rows.add(currentRow);
        }
        int size = rows.size();
        SparseDoubleMatrix2D matrix = new SparseDoubleMatrix2D(size, size);
        for (int i = 0; i < size; ++i) {
            List currentRow = (List)rows.get(i);
            if (currentRow.size() != size) {
                throw new IllegalArgumentException("Matrix must have the same number of rows as columns");
            }
            for (int j = 0; j < size; ++j) {
                double currentVal = (Double)currentRow.get(j);
                if (currentVal == 0.0) continue;
                matrix.setQuick(i, j, currentVal);
            }
        }
        return matrix;
    }

    @Override
    public Graph<V, E> load(String filename) {
        try {
            BufferedReader reader = new BufferedReader(new FileReader(filename));
            Graph<V, E> graph = this.load(reader);
            reader.close();
            return graph;
        }
        catch (IOException ioe) {
            throw new RuntimeException("Error in loading file " + filename, ioe);
        }
    }

    @Override
    public void save(Graph<V, E> graph, String filename) {
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(filename));
            SparseDoubleMatrix2D matrix = GraphMatrixOperations.graphToSparseMatrix(graph, this.mWeightKey);
            for (int i = 0; i < matrix.rows(); ++i) {
                for (int j = 0; j < matrix.columns(); ++j) {
                    writer.write(String.format("%4.2f ", matrix.getQuick(i, j)));
                }
                writer.write("\n");
            }
            writer.close();
        }
        catch (Exception e) {
            throw new RuntimeException("Error saving file: " + filename, e);
        }
    }
}

