/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import javax.media.j3d.AlternateAppearanceRetained;
import javax.media.j3d.AmbientLightRetained;
import javax.media.j3d.BackgroundRetained;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.BoundingLeafRetained;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.ClipRetained;
import javax.media.j3d.FogRetained;
import javax.media.j3d.GeometryAtom;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.J3dStructure;
import javax.media.j3d.LeafRetained;
import javax.media.j3d.LightRetained;
import javax.media.j3d.Locale;
import javax.media.j3d.ModelClipRetained;
import javax.media.j3d.MorphRetained;
import javax.media.j3d.NodeRetained;
import javax.media.j3d.ObjectUpdate;
import javax.media.j3d.OrderedGroupRetained;
import javax.media.j3d.OrientedShape3DRetained;
import javax.media.j3d.RenderAtom;
import javax.media.j3d.Shape3DRetained;
import javax.media.j3d.Transform3D;
import javax.media.j3d.UnorderList;
import javax.media.j3d.UpdateTargets;
import javax.media.j3d.View;
import javax.media.j3d.ViewSpecificGroupRetained;
import javax.media.j3d.VirtualUniverse;
import javax.vecmath.Vector3d;

class RenderingEnvironmentStructure
extends J3dStructure
implements ObjectUpdate {
    ArrayList nonViewScopedLights = new ArrayList();
    HashMap viewScopedLights = new HashMap();
    int numberOfLights = 0;
    ArrayList nonViewScopedFogs = new ArrayList();
    HashMap viewScopedFogs = new HashMap();
    int numberOfFogs = 0;
    ArrayList nonViewScopedAltAppearances = new ArrayList();
    HashMap viewScopedAltAppearances = new HashMap();
    int numberOfAltApps = 0;
    ArrayList nonViewScopedModelClips = new ArrayList();
    HashMap viewScopedModelClips = new HashMap();
    int numberOfModelClips = 0;
    ArrayList nonViewScopedBackgrounds = new ArrayList();
    HashMap viewScopedBackgrounds = new HashMap();
    int numberOfBgs = 0;
    ArrayList nonViewScopedClips = new ArrayList();
    HashMap viewScopedClips = new HashMap();
    int numberOfClips = 0;
    BackgroundRetained[] intersectedBacks = new BackgroundRetained[1];
    ClipRetained[] intersectedClips = new ClipRetained[1];
    Bounds[] intersectedBounds = new Bounds[1];
    Transform3D localeXform = new Transform3D();
    Vector3d localeTranslation = new Vector3d();
    Bounds localeBounds = null;
    FogRetained[] intersectedFogs = new FogRetained[1];
    AlternateAppearanceRetained[] intersectedAltApps = new AlternateAppearanceRetained[1];
    ModelClipRetained[] intersectedModelClips = new ModelClipRetained[1];
    double backClipDistance;
    ArrayList objList = new ArrayList();
    ArrayList xformChangeList = new ArrayList();
    ArrayList objFreeList = new ArrayList();
    LightRetained[] retlights = new LightRetained[5];
    boolean transformMsg = false;
    UpdateTargets targets = null;
    ArrayList blUsers = null;
    Integer ogInsert = new Integer(32);
    Integer ogRemove = new Integer(33);
    Object lockObj = new Object();

    RenderingEnvironmentStructure(VirtualUniverse virtualUniverse) {
        super(virtualUniverse, 4096);
    }

    Object[] getObjectArray() {
        Object[] objectArray;
        int n = this.objFreeList.size();
        if (n == 0) {
            objectArray = new Object[5];
        } else {
            objectArray = (Object[])this.objFreeList.get(n - 1);
            this.objFreeList.remove(n - 1);
        }
        return objectArray;
    }

    void addObjArrayToFreeList(Object[] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            objectArray[n] = null;
            ++n;
        }
        this.objFreeList.add(objectArray);
    }

    public void updateObject() {
        LeafRetained leafRetained;
        int n = this.objList.size();
        int n2 = 0;
        while (n2 < n) {
            Object[] objectArray = (Object[])this.objList.get(n2);
            leafRetained = (LeafRetained)objectArray[0];
            leafRetained.updateMirrorObject(objectArray);
            this.addObjArrayToFreeList(objectArray);
            ++n2;
        }
        this.objList.clear();
        n = this.xformChangeList.size();
        n2 = 0;
        while (n2 < n) {
            leafRetained = (LeafRetained)this.xformChangeList.get(n2);
            leafRetained.updateTransformChange();
            ++n2;
        }
        this.xformChangeList.clear();
    }

    void processMessages(long l) {
        Object[] objectArray = this.getMessages(l);
        int n = this.getNumMessage();
        if (n <= 0) {
            return;
        }
        int n2 = 0;
        while (n2 < n) {
            J3dMessage j3dMessage = objectArray[n2];
            switch (j3dMessage.type) {
                case 0: {
                    this.insertNodes(j3dMessage);
                    break;
                }
                case 1: {
                    this.removeNodes(j3dMessage);
                    break;
                }
                case 19: {
                    this.updateLight(j3dMessage.args);
                    break;
                }
                case 23: {
                    this.updateBoundingLeaf(j3dMessage.args);
                    break;
                }
                case 22: {
                    this.updateFog(j3dMessage.args);
                    break;
                }
                case 41: {
                    this.updateAltApp(j3dMessage.args);
                    break;
                }
                case 24: {
                    this.updateShape3D(j3dMessage.args);
                    break;
                }
                case 46: {
                    this.updateOrientedShape3D(j3dMessage.args);
                    break;
                }
                case 16: {
                    this.updateMorph(j3dMessage.args);
                    break;
                }
                case 3: {
                    this.transformMsg = true;
                    break;
                }
                case 27: {
                    this.processSwitchChanged(j3dMessage);
                    if (!this.universe.transformStructure.getLazyUpdate()) break;
                    this.transformMsg = true;
                    break;
                }
                case 36: {
                    this.updateModelClip(j3dMessage.args);
                    break;
                }
                case 20: {
                    this.updateBackground(j3dMessage.args);
                    break;
                }
                case 21: {
                    this.updateClip(j3dMessage.args);
                    break;
                }
                case 32: {
                    this.updateOrderedGroupInserted(j3dMessage);
                    break;
                }
                case 33: {
                    this.updateOrderedGroupsRemoved(j3dMessage);
                    break;
                }
                case 56: {
                    this.updateViewSpecificGroupChanged(j3dMessage);
                    break;
                }
                case 57: {
                    this.initViewSpecificInfo(j3dMessage);
                    break;
                }
                case 58: {
                    this.clearViewSpecificInfo(j3dMessage);
                }
            }
            j3dMessage.decRefcount();
            ++n2;
        }
        if (this.transformMsg) {
            this.updateTransformChange();
            this.transformMsg = false;
        }
        VirtualUniverse.mc.addMirrorObject(this);
        Arrays.fill(objectArray, 0, n, null);
    }

    void updateOrderedGroupInserted(J3dMessage j3dMessage) {
        Object[] objectArray = (Object[])j3dMessage.args[0];
        Object[] objectArray2 = (Object[])j3dMessage.args[1];
        Object[] objectArray3 = (Object[])j3dMessage.args[2];
        int n = 0;
        while (n < objectArray.length) {
            OrderedGroupRetained orderedGroupRetained = (OrderedGroupRetained)objectArray[n];
            orderedGroupRetained.updateChildIdTableInserted((Integer)objectArray2[n], (Integer)objectArray3[n]);
            orderedGroupRetained.incrChildCount();
            ++n;
        }
    }

    void updateOrderedGroupsRemoved(J3dMessage j3dMessage) {
        Object[] objectArray = (Object[])j3dMessage.args[0];
        Object[] objectArray2 = (Object[])j3dMessage.args[1];
        int n = 0;
        while (n < objectArray.length) {
            OrderedGroupRetained orderedGroupRetained = (OrderedGroupRetained)objectArray[n];
            orderedGroupRetained.updateChildIdTableRemoved((Integer)objectArray2[n]);
            orderedGroupRetained.decrChildCount();
            ++n;
        }
    }

    void processSwitchChanged(J3dMessage j3dMessage) {
        UpdateTargets updateTargets = (UpdateTargets)j3dMessage.args[0];
        UnorderList unorderList = updateTargets.targetList[5];
        if (unorderList != null) {
            Object[] objectArray = (Object[])j3dMessage.args[1];
            int n = unorderList.size();
            Object[] objectArray2 = unorderList.toArray(false);
            int n2 = 0;
            while (n2 < n) {
                Object[] objectArray3 = (Object[])objectArray2[n2];
                Object[] objectArray4 = (Object[])objectArray[n2];
                int n3 = 0;
                while (n3 < objectArray3.length) {
                    Object[] objectArray5 = (Object[])objectArray4[n3];
                    BoundingLeafRetained boundingLeafRetained = (BoundingLeafRetained)objectArray3[n3];
                    int n4 = 0;
                    while (n4 < objectArray5.length) {
                        LeafRetained leafRetained = (LeafRetained)objectArray5[n4];
                        if (leafRetained instanceof FogRetained || leafRetained instanceof LightRetained || leafRetained instanceof ModelClipRetained || leafRetained instanceof ClipRetained || leafRetained instanceof AlternateAppearanceRetained || leafRetained instanceof BackgroundRetained) {
                            leafRetained.updateBoundingLeaf();
                        }
                        ++n4;
                    }
                    ++n3;
                }
                ++n2;
            }
        }
    }

    void insertNodes(J3dMessage j3dMessage) {
        Object object;
        Object[] objectArray = (Object[])j3dMessage.args[0];
        ArrayList arrayList = (ArrayList)j3dMessage.args[3];
        ArrayList arrayList2 = (ArrayList)j3dMessage.args[4];
        int n = 0;
        while (n < objectArray.length) {
            LeafRetained leafRetained;
            object = objectArray[n];
            if (object instanceof LightRetained) {
                LightRetained lightRetained = (LightRetained)object;
                ++this.numberOfLights;
                if (lightRetained.inBackgroundGroup) {
                    lightRetained.geometryBackground.lights.add(lightRetained);
                } else {
                    this.nonViewScopedLights.add(lightRetained);
                }
            } else if (object instanceof FogRetained) {
                FogRetained fogRetained = (FogRetained)object;
                ++this.numberOfFogs;
                if (fogRetained.inBackgroundGroup) {
                    fogRetained.geometryBackground.fogs.add(fogRetained);
                } else {
                    this.nonViewScopedFogs.add(fogRetained);
                }
            } else if (object instanceof AlternateAppearanceRetained) {
                leafRetained = (AlternateAppearanceRetained)object;
                ++this.numberOfAltApps;
                this.nonViewScopedAltAppearances.add(object);
            } else if (object instanceof BackgroundRetained) {
                leafRetained = (BackgroundRetained)object;
                ++this.numberOfBgs;
                this.nonViewScopedBackgrounds.add(object);
            } else if (object instanceof ClipRetained) {
                leafRetained = (ClipRetained)object;
                ++this.numberOfClips;
                this.nonViewScopedClips.add(object);
            } else if (object instanceof ModelClipRetained) {
                ModelClipRetained modelClipRetained = (ModelClipRetained)object;
                ++this.numberOfModelClips;
                this.nonViewScopedModelClips.add(object);
            }
            ++n;
        }
        if (arrayList != null) {
            int n2 = arrayList.size();
            n = 0;
            while (n < n2) {
                ArrayList arrayList3;
                View view;
                int n3;
                int n4;
                object = (NodeRetained)arrayList.get(n);
                ArrayList arrayList4 = (ArrayList)arrayList2.get(n);
                if (object instanceof LightRetained) {
                    ((LightRetained)object).isViewScoped = true;
                    ++this.numberOfLights;
                    n4 = arrayList4.size();
                    n3 = 0;
                    while (n3 < n4) {
                        view = (View)arrayList4.get(n3);
                        arrayList3 = (ArrayList)this.viewScopedLights.get(view);
                        if (arrayList3 == null) {
                            arrayList3 = new ArrayList();
                            this.viewScopedLights.put(view, arrayList3);
                        }
                        arrayList3.add(object);
                        ++n3;
                    }
                } else if (object instanceof FogRetained) {
                    ((FogRetained)object).isViewScoped = true;
                    ++this.numberOfFogs;
                    n4 = arrayList4.size();
                    n3 = 0;
                    while (n3 < n4) {
                        view = (View)arrayList4.get(n3);
                        arrayList3 = (ArrayList)this.viewScopedFogs.get(view);
                        if (arrayList3 == null) {
                            arrayList3 = new ArrayList();
                            this.viewScopedFogs.put(view, arrayList3);
                        }
                        arrayList3.add(object);
                        ++n3;
                    }
                } else if (object instanceof AlternateAppearanceRetained) {
                    ((AlternateAppearanceRetained)object).isViewScoped = true;
                    ++this.numberOfAltApps;
                    n4 = arrayList4.size();
                    n3 = 0;
                    while (n3 < n4) {
                        view = (View)arrayList4.get(n3);
                        arrayList3 = (ArrayList)this.viewScopedAltAppearances.get(view);
                        if (arrayList3 == null) {
                            arrayList3 = new ArrayList();
                            this.viewScopedAltAppearances.put(view, arrayList3);
                        }
                        arrayList3.add(object);
                        ++n3;
                    }
                } else if (object instanceof BackgroundRetained) {
                    ((BackgroundRetained)object).isViewScoped = true;
                    ++this.numberOfBgs;
                    n4 = arrayList4.size();
                    n3 = 0;
                    while (n3 < n4) {
                        view = (View)arrayList4.get(n3);
                        arrayList3 = (ArrayList)this.viewScopedBackgrounds.get(view);
                        if (arrayList3 == null) {
                            arrayList3 = new ArrayList();
                            this.viewScopedBackgrounds.put(view, arrayList3);
                        }
                        arrayList3.add(object);
                        ++n3;
                    }
                } else if (object instanceof ClipRetained) {
                    ((ClipRetained)object).isViewScoped = true;
                    ++this.numberOfClips;
                    n4 = arrayList4.size();
                    n3 = 0;
                    while (n3 < n4) {
                        view = (View)arrayList4.get(n3);
                        arrayList3 = (ArrayList)this.viewScopedClips.get(view);
                        if (arrayList3 == null) {
                            arrayList3 = new ArrayList();
                            this.viewScopedClips.put(view, arrayList3);
                        }
                        arrayList3.add(object);
                        ++n3;
                    }
                } else if (object instanceof ModelClipRetained) {
                    ((ModelClipRetained)object).isViewScoped = true;
                    ++this.numberOfModelClips;
                    n4 = arrayList4.size();
                    n3 = 0;
                    while (n3 < n4) {
                        view = (View)arrayList4.get(n3);
                        arrayList3 = (ArrayList)this.viewScopedModelClips.get(view);
                        if (arrayList3 == null) {
                            arrayList3 = new ArrayList();
                            this.viewScopedModelClips.put(view, arrayList3);
                        }
                        arrayList3.add(object);
                        ++n3;
                    }
                }
                ++n;
            }
        }
        if (this.numberOfLights > this.retlights.length) {
            this.retlights = new LightRetained[this.numberOfLights];
        }
        if (this.intersectedFogs.length < this.numberOfFogs) {
            this.intersectedFogs = new FogRetained[this.numberOfFogs];
        }
        if (this.intersectedAltApps.length < this.numberOfAltApps) {
            this.intersectedAltApps = new AlternateAppearanceRetained[this.numberOfAltApps];
        }
        if (this.intersectedBacks.length < this.numberOfBgs) {
            this.intersectedBacks = new BackgroundRetained[this.numberOfBgs];
        }
        if (this.intersectedClips.length < this.numberOfClips) {
            this.intersectedClips = new ClipRetained[this.numberOfClips];
        }
        if (this.intersectedModelClips.length < this.numberOfModelClips) {
            this.intersectedModelClips = new ModelClipRetained[this.numberOfModelClips];
        }
    }

    void removeNodes(J3dMessage j3dMessage) {
        Object object;
        Object[] objectArray = (Object[])j3dMessage.args[0];
        ArrayList arrayList = (ArrayList)j3dMessage.args[3];
        ArrayList arrayList2 = (ArrayList)j3dMessage.args[4];
        Shape3DRetained shape3DRetained = null;
        int n = 0;
        while (n < objectArray.length) {
            LeafRetained leafRetained;
            object = objectArray[n];
            if (object instanceof LightRetained) {
                leafRetained = (LightRetained)object;
                if (leafRetained.inBackgroundGroup) {
                    leafRetained.geometryBackground.lights.remove(leafRetained);
                } else {
                    this.nonViewScopedLights.remove(this.nonViewScopedLights.indexOf(object));
                }
                --this.numberOfLights;
            } else if (object instanceof FogRetained) {
                --this.numberOfFogs;
                leafRetained = (FogRetained)object;
                if (((FogRetained)leafRetained).inBackgroundGroup) {
                    ((FogRetained)leafRetained).geometryBackground.fogs.remove(leafRetained);
                } else {
                    this.nonViewScopedFogs.remove(this.nonViewScopedFogs.indexOf(object));
                }
            } else if (object instanceof AlternateAppearanceRetained) {
                --this.numberOfAltApps;
                this.nonViewScopedAltAppearances.remove(this.nonViewScopedAltAppearances.indexOf(object));
            } else if (object instanceof BackgroundRetained) {
                --this.numberOfBgs;
                this.nonViewScopedBackgrounds.remove(this.nonViewScopedBackgrounds.indexOf(object));
            } else if (object instanceof ClipRetained) {
                --this.numberOfClips;
                this.nonViewScopedClips.remove(this.nonViewScopedClips.indexOf(object));
            } else if (object instanceof ModelClipRetained) {
                leafRetained = (ModelClipRetained)object;
                --this.numberOfModelClips;
                this.nonViewScopedModelClips.remove(this.nonViewScopedModelClips.indexOf(object));
            } else if (object instanceof GeometryAtom) {
                GeometryAtom geometryAtom = (GeometryAtom)object;
                if (geometryAtom.source != shape3DRetained) {
                    geometryAtom.source.clearMirrorShape();
                    shape3DRetained = geometryAtom.source;
                }
            } else if (object instanceof OrderedGroupRetained) {
                ((OrderedGroupRetained)object).clearDerivedDataStructures();
            }
            ++n;
        }
        if (arrayList != null) {
            int n2 = arrayList.size();
            n = 0;
            while (n < n2) {
                ArrayList arrayList3;
                View view;
                int n3;
                int n4;
                object = (NodeRetained)arrayList.get(n);
                ArrayList arrayList4 = (ArrayList)arrayList2.get(n);
                if (object instanceof LightRetained) {
                    ((LightRetained)object).isViewScoped = false;
                    --this.numberOfLights;
                    n4 = arrayList4.size();
                    n3 = 0;
                    while (n3 < n4) {
                        view = (View)arrayList4.get(n3);
                        arrayList3 = (ArrayList)this.viewScopedLights.get(view);
                        arrayList3.remove(object);
                        if (arrayList3.size() == 0) {
                            this.viewScopedLights.remove(view);
                        }
                        ++n3;
                    }
                } else if (object instanceof FogRetained) {
                    ((FogRetained)object).isViewScoped = false;
                    --this.numberOfFogs;
                    n4 = arrayList4.size();
                    n3 = 0;
                    while (n3 < n4) {
                        view = (View)arrayList4.get(n3);
                        arrayList3 = (ArrayList)this.viewScopedFogs.get(view);
                        arrayList3.remove(object);
                        if (arrayList3.size() == 0) {
                            this.viewScopedFogs.remove(view);
                        }
                        ++n3;
                    }
                } else if (object instanceof AlternateAppearanceRetained) {
                    ((AlternateAppearanceRetained)object).isViewScoped = false;
                    --this.numberOfAltApps;
                    n4 = arrayList4.size();
                    n3 = 0;
                    while (n3 < n4) {
                        view = (View)arrayList4.get(n3);
                        arrayList3 = (ArrayList)this.viewScopedAltAppearances.get(view);
                        arrayList3.remove(object);
                        if (arrayList3.size() == 0) {
                            this.viewScopedAltAppearances.remove(view);
                        }
                        ++n3;
                    }
                } else if (object instanceof BackgroundRetained) {
                    ((BackgroundRetained)object).isViewScoped = false;
                    --this.numberOfBgs;
                    n4 = arrayList4.size();
                    n3 = 0;
                    while (n3 < n4) {
                        view = (View)arrayList4.get(n3);
                        arrayList3 = (ArrayList)this.viewScopedBackgrounds.get(view);
                        arrayList3.remove(object);
                        if (arrayList3.size() == 0) {
                            this.viewScopedBackgrounds.remove(view);
                        }
                        ++n3;
                    }
                } else if (object instanceof ClipRetained) {
                    ((ClipRetained)object).isViewScoped = false;
                    --this.numberOfClips;
                    n4 = arrayList4.size();
                    n3 = 0;
                    while (n3 < n4) {
                        view = (View)arrayList4.get(n3);
                        arrayList3 = (ArrayList)this.viewScopedClips.get(view);
                        arrayList3.remove(object);
                        if (arrayList3.size() == 0) {
                            this.viewScopedClips.remove(view);
                        }
                        ++n3;
                    }
                } else if (object instanceof ModelClipRetained) {
                    ((ModelClipRetained)object).isViewScoped = false;
                    --this.numberOfModelClips;
                    n4 = arrayList4.size();
                    n3 = 0;
                    while (n3 < n4) {
                        view = (View)arrayList4.get(n3);
                        arrayList3 = (ArrayList)this.viewScopedModelClips.get(view);
                        arrayList3.remove(object);
                        if (arrayList3.size() == 0) {
                            this.viewScopedModelClips.remove(view);
                        }
                        ++n3;
                    }
                }
                ++n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LightRetained[] getInfluencingLights(RenderAtom renderAtom, View view) {
        LightRetained[] lightRetainedArray = null;
        LightRetained[] lightRetainedArray2 = this.retlights;
        synchronized (lightRetainedArray2) {
            block14: {
                int n;
                ArrayList arrayList;
                int n2 = 0;
                if (renderAtom.geometryAtom.source.inBackgroundGroup) {
                    arrayList = renderAtom.geometryAtom.source.geometryBackground.lights;
                    n2 = this.processLights(arrayList, renderAtom, n2);
                } else {
                    arrayList = (ArrayList)this.viewScopedLights.get(view);
                    if (arrayList != null) {
                        n2 = this.processLights(arrayList, renderAtom, n2);
                    }
                    n2 = this.processLights(this.nonViewScopedLights, renderAtom, n2);
                }
                boolean bl = false;
                if (renderAtom.lights != null && renderAtom.lights.length == n2) {
                    n = 0;
                    while (n < renderAtom.lights.length) {
                        int n3 = 0;
                        while (n3 < n2) {
                            if (renderAtom.lights[n] == this.retlights[n3]) break;
                            ++n3;
                        }
                        if (n3 == n2) {
                            bl = true;
                            break;
                        }
                        ++n;
                    }
                } else {
                    bl = true;
                }
                if (!bl) break block14;
                lightRetainedArray = new LightRetained[n2];
                n = 0;
                while (n < n2) {
                    lightRetainedArray[n] = this.retlights[n];
                    ++n;
                }
                LightRetained[] lightRetainedArray3 = lightRetainedArray;
                return lightRetainedArray3;
            }
            LightRetained[] lightRetainedArray4 = renderAtom.lights;
            return lightRetainedArray4;
        }
    }

    int processLights(ArrayList arrayList, RenderAtom renderAtom, int n) {
        BoundingBox boundingBox = renderAtom.localeVwcBounds;
        int n2 = arrayList.size();
        if (n2 > 0) {
            int n3 = 0;
            while (n3 < n2) {
                LightRetained lightRetained = (LightRetained)arrayList.get(n3);
                if (lightRetained.lightOn && lightRetained.switchState.currentSwitchOn && (renderAtom.geometryAtom.source.inBackgroundGroup || ((Bounds)boundingBox).intersect(lightRetained.region))) {
                    int n4 = renderAtom.geometryAtom.source.numlights;
                    LightRetained[] lightRetainedArray = renderAtom.geometryAtom.source.lights;
                    if (lightRetained.isScoped) {
                        int n5 = 0;
                        while (n5 < n4) {
                            if (lightRetained == lightRetainedArray[n5]) {
                                this.retlights[n++] = lightRetained;
                                break;
                            }
                            ++n5;
                        }
                    } else {
                        this.retlights[n++] = lightRetained;
                    }
                }
                ++n3;
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FogRetained getInfluencingFog(RenderAtom renderAtom, View view) {
        FogRetained fogRetained = null;
        Object object = this.lockObj;
        synchronized (object) {
            int n = 0;
            BoundingBox boundingBox = renderAtom.localeVwcBounds;
            if (this.intersectedBounds.length < this.numberOfFogs) {
                this.intersectedBounds = new Bounds[this.numberOfFogs];
            }
            if (renderAtom.geometryAtom.source.inBackgroundGroup) {
                ArrayList arrayList = renderAtom.geometryAtom.source.geometryBackground.fogs;
                if ((n = this.processFogs(arrayList, renderAtom, n)) >= 1) {
                    fogRetained = this.intersectedFogs[0];
                }
            } else {
                ArrayList arrayList = (ArrayList)this.viewScopedFogs.get(view);
                if (arrayList != null) {
                    n = this.processFogs(arrayList, renderAtom, n);
                }
                if ((n = this.processFogs(this.nonViewScopedFogs, renderAtom, n)) == 1) {
                    fogRetained = this.intersectedFogs[0];
                } else if (n > 1) {
                    Bounds bounds = ((Bounds)boundingBox).closestIntersection(this.intersectedBounds);
                    int n2 = 0;
                    while (n2 < n) {
                        if (this.intersectedBounds[n2] == bounds) {
                            fogRetained = this.intersectedFogs[n2];
                            break;
                        }
                        ++n2;
                    }
                }
            }
            FogRetained fogRetained2 = fogRetained;
            return fogRetained2;
        }
    }

    int processFogs(ArrayList arrayList, RenderAtom renderAtom, int n) {
        int n2 = arrayList.size();
        BoundingBox boundingBox = renderAtom.localeVwcBounds;
        if (arrayList.size() > 0) {
            int n3 = 0;
            while (n3 < n2) {
                FogRetained fogRetained = (FogRetained)arrayList.get(n3);
                if (fogRetained.region != null && fogRetained.switchState.currentSwitchOn && (renderAtom.geometryAtom.source.inBackgroundGroup || fogRetained.region.intersect(boundingBox))) {
                    int n4 = renderAtom.geometryAtom.source.numfogs;
                    FogRetained[] fogRetainedArray = renderAtom.geometryAtom.source.fogs;
                    if (fogRetained.isScoped) {
                        int n5 = 0;
                        while (n5 < n4) {
                            if (fogRetained == fogRetainedArray[n5]) {
                                this.intersectedBounds[n] = fogRetained.region;
                                this.intersectedFogs[n++] = fogRetained;
                                break;
                            }
                            ++n5;
                        }
                    } else {
                        this.intersectedBounds[n] = fogRetained.region;
                        this.intersectedFogs[n++] = fogRetained;
                    }
                }
                ++n3;
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ModelClipRetained getInfluencingModelClip(RenderAtom renderAtom, View view) {
        ModelClipRetained modelClipRetained = null;
        if (renderAtom.geometryAtom.source.inBackgroundGroup) {
            return null;
        }
        Object object = this.lockObj;
        synchronized (object) {
            ArrayList arrayList;
            BoundingBox boundingBox = renderAtom.localeVwcBounds;
            int n = 0;
            if (this.intersectedBounds.length < this.numberOfModelClips) {
                this.intersectedBounds = new Bounds[this.numberOfModelClips];
            }
            if ((arrayList = (ArrayList)this.viewScopedModelClips.get(view)) != null) {
                n = this.processModelClips(arrayList, renderAtom, n);
            }
            n = this.processModelClips(this.nonViewScopedModelClips, renderAtom, n);
            modelClipRetained = null;
            if (n == 1) {
                modelClipRetained = this.intersectedModelClips[0];
            } else if (n > 1) {
                Bounds bounds = ((Bounds)boundingBox).closestIntersection(this.intersectedBounds);
                int n2 = 0;
                while (n2 < n) {
                    if (this.intersectedBounds[n2] == bounds) {
                        modelClipRetained = this.intersectedModelClips[n2];
                        break;
                    }
                    ++n2;
                }
            }
            ModelClipRetained modelClipRetained2 = modelClipRetained;
            return modelClipRetained2;
        }
    }

    int processModelClips(ArrayList arrayList, RenderAtom renderAtom, int n) {
        int n2 = arrayList.size();
        BoundingBox boundingBox = renderAtom.localeVwcBounds;
        if (n2 > 0) {
            int n3 = 0;
            while (n3 < n2) {
                ModelClipRetained modelClipRetained = (ModelClipRetained)arrayList.get(n3);
                if (modelClipRetained.enableFlag && modelClipRetained.region != null && modelClipRetained.switchState.currentSwitchOn && modelClipRetained.region.intersect(boundingBox)) {
                    int n4 = renderAtom.geometryAtom.source.numModelClips;
                    ModelClipRetained[] modelClipRetainedArray = renderAtom.geometryAtom.source.modelClips;
                    if (modelClipRetained.isScoped) {
                        int n5 = 0;
                        while (n5 < n4) {
                            if (modelClipRetainedArray[n5] == modelClipRetained) {
                                this.intersectedBounds[n] = modelClipRetained.region;
                                this.intersectedModelClips[n++] = modelClipRetained;
                                break;
                            }
                            ++n5;
                        }
                    } else {
                        this.intersectedBounds[n] = modelClipRetained.region;
                        this.intersectedModelClips[n++] = modelClipRetained;
                    }
                }
                ++n3;
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BackgroundRetained getApplicationBackground(BoundingSphere boundingSphere, Locale locale, View view) {
        BackgroundRetained backgroundRetained = null;
        boolean bl = false;
        int n = 0;
        Object object = this.lockObj;
        synchronized (object) {
            ArrayList arrayList;
            int n2 = 0;
            if (this.intersectedBounds.length < this.numberOfBgs) {
                this.intersectedBounds = new Bounds[this.numberOfBgs];
            }
            if ((arrayList = (ArrayList)this.viewScopedBackgrounds.get(view)) != null) {
                n2 = this.processBgs(arrayList, boundingSphere, n2, locale);
            }
            if ((n2 = this.processBgs(this.nonViewScopedBackgrounds, boundingSphere, n2, locale)) == 1) {
                backgroundRetained = this.intersectedBacks[0];
            } else if (n2 > 1) {
                Bounds bounds = boundingSphere.closestIntersection(this.intersectedBounds);
                n = 0;
                while (n < n2) {
                    if (this.intersectedBounds[n] == bounds) {
                        backgroundRetained = this.intersectedBacks[n];
                        break;
                    }
                    ++n;
                }
            }
            BackgroundRetained backgroundRetained2 = backgroundRetained;
            return backgroundRetained2;
        }
    }

    int processBgs(ArrayList arrayList, BoundingSphere boundingSphere, int n, Locale locale) {
        int n2 = arrayList.size();
        int n3 = 0;
        while (n3 < n2) {
            BackgroundRetained backgroundRetained = (BackgroundRetained)arrayList.get(n3);
            if (backgroundRetained.transformedRegion != null && backgroundRetained.switchState.currentSwitchOn) {
                if (backgroundRetained.cachedLocale != locale) {
                    this.localeBounds = (Bounds)backgroundRetained.transformedRegion.clone();
                    backgroundRetained.cachedLocale.hiRes.difference(locale.hiRes, this.localeTranslation);
                    this.localeXform.setIdentity();
                    this.localeXform.setTranslation(this.localeTranslation);
                    this.localeBounds.transform(this.localeXform);
                    if (this.localeBounds.intersect(boundingSphere)) {
                        this.intersectedBounds[n] = this.localeBounds;
                        this.intersectedBacks[n++] = backgroundRetained;
                    }
                } else if (backgroundRetained.transformedRegion.intersect(boundingSphere)) {
                    this.intersectedBounds[n] = backgroundRetained.transformedRegion;
                    this.intersectedBacks[n++] = backgroundRetained;
                }
            }
            ++n3;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    double[] backClipDistanceInVworld(BoundingSphere boundingSphere, View view) {
        Object object = this.lockObj;
        synchronized (object) {
            ArrayList arrayList;
            double[] dArray = null;
            boolean bl = false;
            int n = 0;
            double d = 0.0;
            if (this.intersectedBounds.length < this.numberOfClips) {
                this.intersectedBounds = new Bounds[this.numberOfClips];
            }
            if ((arrayList = (ArrayList)this.viewScopedClips.get(view)) != null) {
                n = this.processClips(arrayList, boundingSphere, n);
            }
            if ((n = this.processClips(this.nonViewScopedClips, boundingSphere, n)) == 1) {
                d = this.intersectedClips[0].backDistanceInVworld;
                bl = true;
            } else if (n > 1) {
                Bounds bounds = boundingSphere.closestIntersection(this.intersectedBounds);
                int n2 = 0;
                while (n2 < n) {
                    if (this.intersectedBounds[n2] == bounds) {
                        d = this.intersectedClips[n2].backDistanceInVworld;
                        bl = true;
                        break;
                    }
                    ++n2;
                }
            }
            if (bl) {
                dArray = new double[]{d};
            }
            double[] dArray2 = dArray;
            return dArray2;
        }
    }

    int processClips(ArrayList arrayList, BoundingSphere boundingSphere, int n) {
        int n2 = arrayList.size();
        int n3 = 0;
        while (n3 < n2) {
            ClipRetained clipRetained = (ClipRetained)arrayList.get(n3);
            if (clipRetained.transformedRegion.intersect(boundingSphere) && clipRetained.switchState.currentSwitchOn) {
                this.intersectedBounds[n] = clipRetained.transformedRegion;
                this.intersectedClips[n++] = clipRetained;
            }
            ++n3;
        }
        return n;
    }

    void updateLight(Object[] objectArray) {
        LightRetained lightRetained = (LightRetained)objectArray[0];
        int n = (Integer)objectArray[1];
        if ((n & 0x20) != 0) {
            lightRetained.initMirrorObject(objectArray);
        }
        if (lightRetained instanceof AmbientLightRetained && (n & 8) != 0) {
            lightRetained.updateImmediateMirrorObject(objectArray);
        } else if ((n & 0xFA8) != 0) {
            Object[] objectArray2 = this.getObjectArray();
            objectArray2[0] = objectArray[0];
            objectArray2[1] = objectArray[1];
            objectArray2[2] = objectArray[2];
            objectArray2[3] = objectArray[3];
            objectArray2[4] = objectArray[4];
            this.objList.add(objectArray2);
        } else if ((n & 0x40) != 0) {
            lightRetained.clearMirrorObject(objectArray);
        } else {
            lightRetained.updateImmediateMirrorObject(objectArray);
        }
    }

    void updateBackground(Object[] objectArray) {
        BackgroundRetained backgroundRetained = (BackgroundRetained)objectArray[0];
        backgroundRetained.updateImmediateMirrorObject(objectArray);
    }

    void updateFog(Object[] objectArray) {
        FogRetained fogRetained = (FogRetained)objectArray[0];
        int n = (Integer)objectArray[1];
        if ((n & 0x10) != 0) {
            fogRetained.initMirrorObject(objectArray);
            Object[] objectArray2 = this.getObjectArray();
            objectArray2[0] = objectArray[0];
            objectArray2[1] = objectArray[1];
            objectArray2[2] = objectArray[2];
            objectArray2[3] = objectArray[3];
            objectArray2[4] = objectArray[4];
            this.objList.add(objectArray2);
        } else if ((n & 0x20) != 0) {
            fogRetained.clearMirrorObject(objectArray);
        } else if ((n & 0xC1) != 0) {
            Object[] objectArray3 = this.getObjectArray();
            objectArray3[0] = objectArray[0];
            objectArray3[1] = objectArray[1];
            objectArray3[2] = objectArray[2];
            objectArray3[3] = objectArray[3];
            objectArray3[4] = objectArray[4];
            this.objList.add(objectArray3);
        } else {
            fogRetained.updateImmediateMirrorObject(objectArray);
        }
    }

    void updateAltApp(Object[] objectArray) {
        AlternateAppearanceRetained alternateAppearanceRetained = (AlternateAppearanceRetained)objectArray[0];
        int n = (Integer)objectArray[1];
        if ((n & 0x10) != 0) {
            AlternateAppearanceRetained alternateAppearanceRetained2 = (AlternateAppearanceRetained)objectArray[0];
            alternateAppearanceRetained2.initMirrorObject(objectArray);
        } else if ((n & 0x20) != 0) {
            AlternateAppearanceRetained alternateAppearanceRetained3 = (AlternateAppearanceRetained)objectArray[0];
            alternateAppearanceRetained3.clearMirrorObject(objectArray);
        } else {
            alternateAppearanceRetained.updateImmediateMirrorObject(objectArray);
        }
    }

    void updateClip(Object[] objectArray) {
        ClipRetained clipRetained = (ClipRetained)objectArray[0];
        clipRetained.updateImmediateMirrorObject(objectArray);
    }

    void updateModelClip(Object[] objectArray) {
        ModelClipRetained modelClipRetained = (ModelClipRetained)objectArray[0];
        int n = (Integer)objectArray[1];
        if ((n & 0x80) != 0) {
            modelClipRetained.initMirrorObject(objectArray);
        }
        if ((n & 0x100) != 0) {
            modelClipRetained.clearMirrorObject(objectArray);
        } else if ((n & 0x83) != 0) {
            Object[] objectArray2 = this.getObjectArray();
            objectArray2[0] = objectArray[0];
            objectArray2[1] = objectArray[1];
            objectArray2[2] = objectArray[2];
            objectArray2[3] = objectArray[3];
            objectArray2[4] = objectArray[4];
            this.objList.add(objectArray2);
        } else {
            modelClipRetained.updateImmediateMirrorObject(objectArray);
        }
    }

    void updateBoundingLeaf(Object[] objectArray) {
        BoundingLeafRetained boundingLeafRetained = (BoundingLeafRetained)objectArray[0];
        Object[] objectArray2 = (Object[])objectArray[3];
        boundingLeafRetained.updateImmediateMirrorObject(objectArray);
        int n = 0;
        while (n < objectArray2.length) {
            LeafRetained leafRetained = (LeafRetained)objectArray2[n];
            leafRetained.updateBoundingLeaf();
            ++n;
        }
    }

    void updateShape3D(Object[] objectArray) {
        Shape3DRetained shape3DRetained = (Shape3DRetained)objectArray[0];
        shape3DRetained.updateImmediateMirrorObject(objectArray);
    }

    void updateOrientedShape3D(Object[] objectArray) {
        OrientedShape3DRetained orientedShape3DRetained = (OrientedShape3DRetained)objectArray[4];
        orientedShape3DRetained.updateImmediateMirrorObject(objectArray);
    }

    void updateMorph(Object[] objectArray) {
        MorphRetained morphRetained = (MorphRetained)objectArray[0];
        morphRetained.updateImmediateMirrorObject(objectArray);
    }

    void updateTransformChange() {
        LeafRetained leafRetained;
        int n;
        Object[] objectArray;
        int n2;
        Object[] objectArray2;
        int n3;
        this.targets = this.universe.transformStructure.getTargetList();
        this.blUsers = this.universe.transformStructure.getBlUsers();
        UnorderList unorderList = this.targets.targetList[1];
        if (unorderList != null) {
            n3 = unorderList.size();
            objectArray2 = unorderList.toArray(false);
            n2 = 0;
            while (n2 < n3) {
                objectArray = (Object[])objectArray2[n2];
                n = 0;
                while (n < objectArray.length) {
                    if (objectArray[n] instanceof LightRetained) {
                        LightRetained lightRetained = (LightRetained)objectArray[n];
                        lightRetained.updateImmediateTransformChange();
                        this.xformChangeList.add(objectArray[n]);
                    } else if (objectArray[n] instanceof FogRetained) {
                        leafRetained = (FogRetained)objectArray[n];
                        ((FogRetained)leafRetained).updateImmediateTransformChange();
                        this.xformChangeList.add(objectArray[n]);
                    } else if (objectArray[n] instanceof AlternateAppearanceRetained) {
                        leafRetained = (AlternateAppearanceRetained)objectArray[n];
                        ((AlternateAppearanceRetained)leafRetained).updateImmediateTransformChange();
                        this.xformChangeList.add(objectArray[n]);
                    } else if (objectArray[n] instanceof BackgroundRetained) {
                        leafRetained = (BackgroundRetained)objectArray[n];
                        ((BackgroundRetained)leafRetained).updateImmediateTransformChange();
                    } else if (objectArray[n] instanceof ModelClipRetained) {
                        leafRetained = (ModelClipRetained)objectArray[n];
                        ((ModelClipRetained)leafRetained).updateImmediateTransformChange();
                    }
                    ++n;
                }
                ++n2;
            }
        }
        if ((unorderList = this.targets.targetList[5]) != null) {
            n3 = unorderList.size();
            objectArray2 = unorderList.toArray(false);
            n2 = 0;
            while (n2 < n3) {
                objectArray = (Object[])objectArray2[n2];
                n = 0;
                while (n < objectArray.length) {
                    BoundingLeafRetained boundingLeafRetained = (BoundingLeafRetained)objectArray[n];
                    boundingLeafRetained.updateImmediateTransformChange();
                    ++n;
                }
                ++n2;
            }
        }
        if (this.blUsers != null) {
            n = 0;
            while (n < this.blUsers.size()) {
                leafRetained = (LeafRetained)this.blUsers.get(n);
                leafRetained.updateBoundingLeaf();
                ++n;
            }
        }
        this.targets = null;
        this.blUsers = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object[] getInfluencingAppearance(RenderAtom renderAtom, View view) {
        AlternateAppearanceRetained alternateAppearanceRetained = null;
        Object[] objectArray = new Object[2];
        if (renderAtom.geometryAtom.source.inBackgroundGroup) {
            objectArray[0] = Boolean.FALSE;
            return objectArray;
        }
        Object object = this.lockObj;
        synchronized (object) {
            block12: {
                ArrayList arrayList;
                int n = 0;
                BoundingBox boundingBox = renderAtom.localeVwcBounds;
                if (this.intersectedBounds.length < this.numberOfAltApps) {
                    this.intersectedBounds = new Bounds[this.numberOfAltApps];
                }
                if ((arrayList = (ArrayList)this.viewScopedAltAppearances.get(view)) != null) {
                    n = this.processAltApps(arrayList, renderAtom, n);
                }
                n = this.processAltApps(this.nonViewScopedAltAppearances, renderAtom, n);
                alternateAppearanceRetained = null;
                if (n == 1) {
                    alternateAppearanceRetained = this.intersectedAltApps[0];
                } else if (n > 1) {
                    Bounds bounds = ((Bounds)boundingBox).closestIntersection(this.intersectedBounds);
                    int n2 = 0;
                    while (n2 < n) {
                        if (this.intersectedBounds[n2] == bounds) {
                            alternateAppearanceRetained = this.intersectedAltApps[n2];
                            break;
                        }
                        ++n2;
                    }
                }
                if (alternateAppearanceRetained != null) break block12;
                objectArray[0] = Boolean.FALSE;
                Object[] objectArray2 = objectArray;
                return objectArray2;
            }
            objectArray[0] = Boolean.TRUE;
            objectArray[1] = alternateAppearanceRetained.appearance;
            Object[] objectArray3 = objectArray;
            return objectArray3;
        }
    }

    int processAltApps(ArrayList arrayList, RenderAtom renderAtom, int n) {
        int n2 = arrayList.size();
        BoundingBox boundingBox = renderAtom.localeVwcBounds;
        if (n2 > 0) {
            int n3 = 0;
            while (n3 < n2) {
                AlternateAppearanceRetained alternateAppearanceRetained = (AlternateAppearanceRetained)arrayList.get(n3);
                if (alternateAppearanceRetained.region != null && alternateAppearanceRetained.switchState.currentSwitchOn && alternateAppearanceRetained.region.intersect(boundingBox)) {
                    int n4 = renderAtom.geometryAtom.source.numAltApps;
                    AlternateAppearanceRetained[] alternateAppearanceRetainedArray = renderAtom.geometryAtom.source.altApps;
                    if (alternateAppearanceRetained.isScoped) {
                        int n5 = 0;
                        while (n5 < n4) {
                            if (alternateAppearanceRetained == alternateAppearanceRetainedArray[n5]) {
                                this.intersectedBounds[n] = alternateAppearanceRetained.region;
                                this.intersectedAltApps[n++] = alternateAppearanceRetained;
                                break;
                            }
                            ++n5;
                        }
                    } else {
                        this.intersectedBounds[n] = alternateAppearanceRetained.region;
                        this.intersectedAltApps[n++] = alternateAppearanceRetained;
                    }
                }
                ++n3;
            }
        }
        return n;
    }

    void initViewSpecificInfo(J3dMessage j3dMessage) {
        int[] nArray = (int[])j3dMessage.args[2];
        ArrayList arrayList = (ArrayList)j3dMessage.args[1];
        ArrayList arrayList2 = (ArrayList)j3dMessage.args[0];
        if (arrayList2 != null) {
            int n = arrayList2.size();
            int n2 = 0;
            while (n2 < n) {
                ViewSpecificGroupRetained viewSpecificGroupRetained = (ViewSpecificGroupRetained)arrayList2.get(n2);
                ArrayList arrayList3 = (ArrayList)arrayList.get(n2);
                int n3 = nArray[n2];
                viewSpecificGroupRetained.cachedViewList.add(n3, arrayList3);
                ++n2;
            }
        }
    }

    void clearViewSpecificInfo(J3dMessage j3dMessage) {
        int[] nArray = (int[])j3dMessage.args[1];
        ArrayList arrayList = (ArrayList)j3dMessage.args[0];
        if (arrayList != null) {
            int n = arrayList.size();
            int n2 = 0;
            while (n2 < n) {
                ViewSpecificGroupRetained viewSpecificGroupRetained = (ViewSpecificGroupRetained)arrayList.get(n2);
                int n3 = nArray[n2];
                if (n3 == -1) {
                    int n4 = viewSpecificGroupRetained.cachedViewList.size();
                    int n5 = 0;
                    while (n5 < n4) {
                        ArrayList arrayList2 = (ArrayList)viewSpecificGroupRetained.cachedViewList.get(n5);
                        arrayList2.clear();
                        ++n5;
                    }
                    viewSpecificGroupRetained.cachedViewList.clear();
                } else {
                    ArrayList arrayList3 = (ArrayList)viewSpecificGroupRetained.cachedViewList.remove(n3);
                    arrayList3.clear();
                }
                ++n2;
            }
        }
    }

    void updateViewSpecificGroupChanged(J3dMessage j3dMessage) {
        Object e;
        Object object;
        ViewSpecificGroupRetained viewSpecificGroupRetained;
        int n;
        int n2;
        Object object2;
        Object object3;
        ArrayList arrayList;
        Object object4;
        int n3 = (Integer)j3dMessage.args[0];
        Object[] objectArray = (Object[])j3dMessage.args[1];
        ArrayList arrayList2 = null;
        ArrayList arrayList3 = null;
        ArrayList arrayList4 = null;
        ArrayList arrayList5 = null;
        ArrayList arrayList6 = null;
        ArrayList arrayList7 = null;
        if ((n3 & 2) != 0 || (n3 & 1) != 0) {
            object4 = (View)objectArray[0];
            arrayList = (ArrayList)objectArray[1];
            object3 = (ArrayList)objectArray[2];
            object2 = (int[])objectArray[3];
            n2 = arrayList.size();
            if (object4 != null) {
                n = 0;
                while (n < n2) {
                    viewSpecificGroupRetained = (ViewSpecificGroupRetained)arrayList.get(n);
                    object = object2[n];
                    viewSpecificGroupRetained.updateCachedInformation(2, (View)object4, (int)object);
                    ++n;
                }
                n2 = ((ArrayList)object3).size();
                if (n2 > 0) {
                    n = 0;
                    while (n < n2) {
                        e = ((ArrayList)object3).get(n);
                        if (e instanceof LightRetained) {
                            ((LightRetained)e).isViewScoped = true;
                            ++this.numberOfLights;
                            if (arrayList2 == null && (arrayList2 = (ArrayList)this.viewScopedLights.get(object4)) == null) {
                                arrayList2 = new ArrayList();
                                this.viewScopedLights.put(object4, arrayList2);
                            }
                            arrayList2.add(e);
                        }
                        if (e instanceof FogRetained) {
                            ((FogRetained)e).isViewScoped = true;
                            ++this.numberOfFogs;
                            if (arrayList3 == null && (arrayList3 = (ArrayList)this.viewScopedFogs.get(object4)) == null) {
                                arrayList3 = new ArrayList();
                                this.viewScopedFogs.put(object4, arrayList3);
                            }
                            arrayList3.add(e);
                        }
                        if (e instanceof ModelClipRetained) {
                            ((ModelClipRetained)e).isViewScoped = true;
                            ++this.numberOfModelClips;
                            if (arrayList4 == null && (arrayList4 = (ArrayList)this.viewScopedModelClips.get(object4)) == null) {
                                arrayList4 = new ArrayList();
                                this.viewScopedModelClips.put(object4, arrayList4);
                            }
                            arrayList4.add(e);
                        }
                        if (e instanceof AlternateAppearanceRetained) {
                            ((AlternateAppearanceRetained)e).isViewScoped = true;
                            ++this.numberOfAltApps;
                            if (arrayList5 == null && (arrayList5 = (ArrayList)this.viewScopedAltAppearances.get(object4)) == null) {
                                arrayList5 = new ArrayList();
                                this.viewScopedAltAppearances.put(object4, arrayList5);
                            }
                            arrayList5.add(e);
                        }
                        if (e instanceof ClipRetained) {
                            ((ClipRetained)e).isViewScoped = true;
                            ++this.numberOfClips;
                            if (arrayList7 == null && (arrayList7 = (ArrayList)this.viewScopedClips.get(object4)) == null) {
                                arrayList7 = new ArrayList();
                                this.viewScopedClips.put(object4, arrayList7);
                            }
                            arrayList7.add(e);
                        }
                        if (e instanceof BackgroundRetained) {
                            ((BackgroundRetained)e).isViewScoped = true;
                            ++this.numberOfBgs;
                            if (arrayList6 == null && (arrayList6 = (ArrayList)this.viewScopedBackgrounds.get(object4)) == null) {
                                arrayList6 = new ArrayList();
                                this.viewScopedBackgrounds.put(object4, arrayList6);
                            }
                            arrayList6.add(e);
                        }
                        ++n;
                    }
                    if (this.numberOfLights > this.retlights.length) {
                        this.retlights = new LightRetained[this.numberOfLights];
                    }
                    if (this.intersectedFogs.length < this.numberOfFogs) {
                        this.intersectedFogs = new FogRetained[this.numberOfFogs];
                    }
                    if (this.intersectedAltApps.length < this.numberOfAltApps) {
                        this.intersectedAltApps = new AlternateAppearanceRetained[this.numberOfAltApps];
                    }
                    if (this.intersectedBacks.length < this.numberOfBgs) {
                        this.intersectedBacks = new BackgroundRetained[this.numberOfBgs];
                    }
                    if (this.intersectedClips.length < this.numberOfClips) {
                        this.intersectedClips = new ClipRetained[this.numberOfClips];
                    }
                    if (this.intersectedModelClips.length < this.numberOfModelClips) {
                        this.intersectedModelClips = new ModelClipRetained[this.numberOfModelClips];
                    }
                }
            }
        }
        if ((n3 & 4) != 0 || (n3 & 1) != 0) {
            if ((n3 & 4) != 0) {
                object2 = (View)objectArray[0];
                object4 = (ArrayList)objectArray[1];
                arrayList = (ArrayList)objectArray[2];
                object3 = (int[])objectArray[3];
            } else {
                object2 = (View)objectArray[4];
                object4 = (ArrayList)objectArray[5];
                arrayList = (ArrayList)objectArray[6];
                object3 = (int[])objectArray[7];
            }
            if (object2 != null) {
                n2 = ((ArrayList)object4).size();
                n = 0;
                while (n < n2) {
                    viewSpecificGroupRetained = (ViewSpecificGroupRetained)((ArrayList)object4).get(n);
                    object = object3[n];
                    viewSpecificGroupRetained.updateCachedInformation(4, (View)object2, (int)object);
                    ++n;
                }
                n2 = arrayList.size();
                if (n2 > 0) {
                    n = 0;
                    while (n < n2) {
                        e = arrayList.get(n);
                        if (e instanceof LightRetained) {
                            ((LightRetained)e).isViewScoped = false;
                            --this.numberOfLights;
                            if (arrayList2 == null) {
                                arrayList2 = (ArrayList)this.viewScopedLights.get(object2);
                            }
                            arrayList2.remove(e);
                        }
                        if (e instanceof FogRetained) {
                            ((FogRetained)e).isViewScoped = false;
                            --this.numberOfFogs;
                            if (arrayList3 == null) {
                                arrayList3 = (ArrayList)this.viewScopedFogs.get(object2);
                            }
                            arrayList3.remove(e);
                        }
                        if (e instanceof ModelClipRetained) {
                            ((ModelClipRetained)e).isViewScoped = false;
                            --this.numberOfModelClips;
                            if (arrayList4 == null) {
                                arrayList4 = (ArrayList)this.viewScopedModelClips.get(object2);
                            }
                            arrayList4.remove(e);
                        }
                        if (e instanceof AlternateAppearanceRetained) {
                            ((AlternateAppearanceRetained)e).isViewScoped = false;
                            --this.numberOfAltApps;
                            if (arrayList5 == null) {
                                arrayList5 = (ArrayList)this.viewScopedAltAppearances.get(object2);
                            }
                            arrayList5.remove(e);
                        }
                        if (e instanceof ClipRetained) {
                            ((ClipRetained)e).isViewScoped = false;
                            --this.numberOfClips;
                            if (arrayList7 == null) {
                                arrayList7 = (ArrayList)this.viewScopedClips.get(object2);
                            }
                            arrayList7.remove(e);
                        }
                        if (e instanceof BackgroundRetained) {
                            ((BackgroundRetained)e).isViewScoped = false;
                            ++this.numberOfBgs;
                            if (arrayList6 == null) {
                                arrayList6 = (ArrayList)this.viewScopedBackgrounds.get(object2);
                            }
                            arrayList6.remove(e);
                        }
                        ++n;
                    }
                    if (arrayList2 != null && arrayList2.size() == 0) {
                        this.viewScopedLights.remove(object2);
                    }
                    if (arrayList3 != null && arrayList3.size() == 0) {
                        this.viewScopedFogs.remove(object2);
                    }
                    if (arrayList4 != null && arrayList4.size() == 0) {
                        this.viewScopedModelClips.remove(object2);
                    }
                    if (arrayList5 != null && arrayList5.size() == 0) {
                        this.viewScopedAltAppearances.remove(object2);
                    }
                    if (arrayList7 != null && arrayList7.size() == 0) {
                        this.viewScopedClips.remove(object2);
                    }
                    if (arrayList6 != null && arrayList6.size() == 0) {
                        this.viewScopedBackgrounds.remove(object2);
                    }
                }
            }
        }
    }

    boolean isLightScopedToThisView(Object object, View view) {
        ArrayList arrayList;
        LightRetained lightRetained = (LightRetained)object;
        return !lightRetained.isViewScoped || (arrayList = (ArrayList)this.viewScopedLights.get(view)) != null && arrayList.contains(lightRetained);
    }

    boolean isFogScopedToThisView(Object object, View view) {
        ArrayList arrayList;
        FogRetained fogRetained = (FogRetained)object;
        return !fogRetained.isViewScoped || (arrayList = (ArrayList)this.viewScopedFogs.get(view)) != null && arrayList.contains(fogRetained);
    }

    boolean isAltAppScopedToThisView(Object object, View view) {
        ArrayList arrayList;
        AlternateAppearanceRetained alternateAppearanceRetained = (AlternateAppearanceRetained)object;
        return !alternateAppearanceRetained.isViewScoped || (arrayList = (ArrayList)this.viewScopedAltAppearances.get(view)) != null && arrayList.contains(alternateAppearanceRetained);
    }

    boolean isBgScopedToThisView(Object object, View view) {
        ArrayList arrayList;
        BackgroundRetained backgroundRetained = (BackgroundRetained)object;
        return !backgroundRetained.isViewScoped || (arrayList = (ArrayList)this.viewScopedBackgrounds.get(view)) != null && arrayList.contains(backgroundRetained);
    }

    boolean isClipScopedToThisView(Object object, View view) {
        ArrayList arrayList;
        ClipRetained clipRetained = (ClipRetained)object;
        return !clipRetained.isViewScoped || (arrayList = (ArrayList)this.viewScopedClips.get(view)) != null && arrayList.contains(clipRetained);
    }

    boolean isMclipScopedToThisView(Object object, View view) {
        ArrayList arrayList;
        ModelClipRetained modelClipRetained = (ModelClipRetained)object;
        return !modelClipRetained.isViewScoped || (arrayList = (ArrayList)this.viewScopedModelClips.get(view)) != null && arrayList.contains(modelClipRetained);
    }

    void cleanup() {
    }
}

