/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.CapabilityNotSetException;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.NodeComponent;
import javax.media.j3d.PolygonAttributesRetained;

public class PolygonAttributes
extends NodeComponent {
    public static final int ALLOW_CULL_FACE_READ = 0;
    public static final int ALLOW_CULL_FACE_WRITE = 1;
    public static final int ALLOW_NORMAL_FLIP_READ = 6;
    public static final int ALLOW_NORMAL_FLIP_WRITE = 7;
    public static final int ALLOW_MODE_READ = 2;
    public static final int ALLOW_MODE_WRITE = 3;
    public static final int ALLOW_OFFSET_READ = 4;
    public static final int ALLOW_OFFSET_WRITE = 5;
    public static final int POLYGON_POINT = 0;
    public static final int POLYGON_LINE = 1;
    public static final int POLYGON_FILL = 2;
    public static final int CULL_NONE = 0;
    public static final int CULL_BACK = 1;
    public static final int CULL_FRONT = 2;

    public PolygonAttributes() {
    }

    public PolygonAttributes(int n, int n2, float f) {
        this(n, n2, f, false, 0.0f);
    }

    public PolygonAttributes(int n, int n2, float f, boolean bl) {
        this(n, n2, f, bl, 0.0f);
    }

    public PolygonAttributes(int n, int n2, float f, boolean bl, float f2) {
        if (n < 0 || n > 2) {
            throw new IllegalArgumentException(J3dI18N.getString("PolygonAttributes0"));
        }
        if (n2 < 0 || n2 > 2) {
            throw new IllegalArgumentException(J3dI18N.getString("PolygonAttributes12"));
        }
        ((PolygonAttributesRetained)this.retained).initPolygonMode(n);
        ((PolygonAttributesRetained)this.retained).initCullFace(n2);
        ((PolygonAttributesRetained)this.retained).initPolygonOffset(f);
        ((PolygonAttributesRetained)this.retained).initBackFaceNormalFlip(bl);
        ((PolygonAttributesRetained)this.retained).initPolygonOffsetFactor(f2);
    }

    public void setCullFace(int n) {
        if (this.isLiveOrCompiled() && !this.getCapability(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("PolygonAttributes2"));
        }
        if (n < 0 || n > 2) {
            throw new IllegalArgumentException(J3dI18N.getString("PolygonAttributes3"));
        }
        if (this.isLive()) {
            ((PolygonAttributesRetained)this.retained).setCullFace(n);
        } else {
            ((PolygonAttributesRetained)this.retained).initCullFace(n);
        }
    }

    public int getCullFace() {
        if (this.isLiveOrCompiled() && !this.getCapability(0)) {
            throw new CapabilityNotSetException(J3dI18N.getString("PolygonAttributes4"));
        }
        return ((PolygonAttributesRetained)this.retained).getCullFace();
    }

    public void setBackFaceNormalFlip(boolean bl) {
        if (this.isLiveOrCompiled() && !this.getCapability(7)) {
            throw new CapabilityNotSetException(J3dI18N.getString("PolygonAttributes5"));
        }
        if (this.isLive()) {
            ((PolygonAttributesRetained)this.retained).setBackFaceNormalFlip(bl);
        } else {
            ((PolygonAttributesRetained)this.retained).initBackFaceNormalFlip(bl);
        }
    }

    public boolean getBackFaceNormalFlip() {
        if (this.isLiveOrCompiled() && !this.getCapability(6)) {
            throw new CapabilityNotSetException(J3dI18N.getString("PolygonAttributes6"));
        }
        return ((PolygonAttributesRetained)this.retained).getBackFaceNormalFlip();
    }

    public void setPolygonMode(int n) {
        if (this.isLiveOrCompiled() && !this.getCapability(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("PolygonAttributes7"));
        }
        if (n < 0 || n > 2) {
            throw new IllegalArgumentException(J3dI18N.getString("PolygonAttributes8"));
        }
        if (this.isLive()) {
            ((PolygonAttributesRetained)this.retained).setPolygonMode(n);
        } else {
            ((PolygonAttributesRetained)this.retained).initPolygonMode(n);
        }
    }

    public int getPolygonMode() {
        if (this.isLiveOrCompiled() && !this.getCapability(2)) {
            throw new CapabilityNotSetException(J3dI18N.getString("PolygonAttributes9"));
        }
        return ((PolygonAttributesRetained)this.retained).getPolygonMode();
    }

    public void setPolygonOffset(float f) {
        if (this.isLiveOrCompiled() && !this.getCapability(5)) {
            throw new CapabilityNotSetException(J3dI18N.getString("PolygonAttributes10"));
        }
        if (this.isLive()) {
            ((PolygonAttributesRetained)this.retained).setPolygonOffset(f);
        } else {
            ((PolygonAttributesRetained)this.retained).initPolygonOffset(f);
        }
    }

    public float getPolygonOffset() {
        if (this.isLiveOrCompiled() && !this.getCapability(4)) {
            throw new CapabilityNotSetException(J3dI18N.getString("PolygonAttributes11"));
        }
        return ((PolygonAttributesRetained)this.retained).getPolygonOffset();
    }

    public void setPolygonOffsetFactor(float f) {
        if (this.isLiveOrCompiled() && !this.getCapability(5)) {
            throw new CapabilityNotSetException(J3dI18N.getString("PolygonAttributes10"));
        }
        if (this.isLive()) {
            ((PolygonAttributesRetained)this.retained).setPolygonOffsetFactor(f);
        } else {
            ((PolygonAttributesRetained)this.retained).initPolygonOffsetFactor(f);
        }
    }

    public float getPolygonOffsetFactor() {
        if (this.isLiveOrCompiled() && !this.getCapability(4)) {
            throw new CapabilityNotSetException(J3dI18N.getString("PolygonAttributes11"));
        }
        return ((PolygonAttributesRetained)this.retained).getPolygonOffsetFactor();
    }

    void createRetained() {
        this.retained = new PolygonAttributesRetained();
        this.retained.setSource(this);
    }

    public NodeComponent cloneNodeComponent() {
        PolygonAttributes polygonAttributes = new PolygonAttributes();
        polygonAttributes.duplicateNodeComponent(this);
        return polygonAttributes;
    }

    void duplicateAttributes(NodeComponent nodeComponent, boolean bl) {
        super.duplicateAttributes(nodeComponent, bl);
        PolygonAttributesRetained polygonAttributesRetained = (PolygonAttributesRetained)nodeComponent.retained;
        PolygonAttributesRetained polygonAttributesRetained2 = (PolygonAttributesRetained)this.retained;
        polygonAttributesRetained2.initCullFace(polygonAttributesRetained.getCullFace());
        polygonAttributesRetained2.initBackFaceNormalFlip(polygonAttributesRetained.getBackFaceNormalFlip());
        polygonAttributesRetained2.initPolygonMode(polygonAttributesRetained.getPolygonMode());
        polygonAttributesRetained2.initPolygonOffset(polygonAttributesRetained.getPolygonOffset());
        polygonAttributesRetained2.initPolygonOffsetFactor(polygonAttributesRetained.getPolygonOffsetFactor());
    }
}

