/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import javax.media.j3d.BehaviorRetained;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.BranchGroupRetained;
import javax.media.j3d.CapabilityNotSetException;
import javax.media.j3d.HiResCoord;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.MasterControl;
import javax.media.j3d.MultipleParentException;
import javax.media.j3d.OrderedPath;
import javax.media.j3d.PickShape;
import javax.media.j3d.Picking;
import javax.media.j3d.SceneGraphPath;
import javax.media.j3d.SetLiveState;
import javax.media.j3d.SwitchState;
import javax.media.j3d.Transform3D;
import javax.media.j3d.VirtualUniverse;

public class Locale {
    VirtualUniverse universe;
    HiResCoord hiRes;
    Vector branchGroups = new Vector();
    String nodeId = null;

    public Locale(VirtualUniverse virtualUniverse) {
        this.universe = virtualUniverse;
        this.universe.addLocale(this);
        this.hiRes = new HiResCoord();
        this.nodeId = virtualUniverse.getNodeId();
    }

    public Locale(VirtualUniverse virtualUniverse, int[] nArray, int[] nArray2, int[] nArray3) {
        this.universe = virtualUniverse;
        this.universe.addLocale(this);
        this.hiRes = new HiResCoord(nArray, nArray2, nArray3);
        this.nodeId = virtualUniverse.getNodeId();
    }

    public Locale(VirtualUniverse virtualUniverse, HiResCoord hiResCoord) {
        this.universe = virtualUniverse;
        this.universe.addLocale(this);
        this.hiRes = new HiResCoord(hiResCoord);
        this.nodeId = virtualUniverse.getNodeId();
    }

    public VirtualUniverse getVirtualUniverse() {
        return this.universe;
    }

    public void setHiRes(int[] nArray, int[] nArray2, int[] nArray3) {
        this.hiRes.setHiResCoord(nArray, nArray2, nArray3);
    }

    public void setHiRes(HiResCoord hiResCoord) {
        this.hiRes.setHiResCoord(hiResCoord);
    }

    public void getHiRes(HiResCoord hiResCoord) {
        this.hiRes.getHiResCoord(hiResCoord);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBranchGraph(BranchGroup branchGroup) {
        if (this.universe == null) {
            throw new IllegalStateException(J3dI18N.getString("Locale4"));
        }
        if (((BranchGroupRetained)branchGroup.retained).parent != null || branchGroup.isLive()) {
            throw new MultipleParentException(J3dI18N.getString("Locale0"));
        }
        this.universe.resetWaitMCFlag();
        Object object = this.universe.sceneGraphLock;
        synchronized (object) {
            this.doAddBranchGraph(branchGroup);
            this.universe.setLiveState.reset(this);
        }
        this.universe.waitForMC();
    }

    void doAddBranchGraph(BranchGroup branchGroup) {
        BranchGroupRetained branchGroupRetained = (BranchGroupRetained)branchGroup.retained;
        SetLiveState setLiveState = this.universe.setLiveState;
        branchGroupRetained.attachedToLocale = true;
        this.branchGroups.addElement(branchGroup);
        setLiveState.reset(this);
        setLiveState.currentTransforms[0] = new Transform3D[2];
        setLiveState.currentTransforms[0][0] = new Transform3D();
        setLiveState.currentTransforms[0][1] = new Transform3D();
        setLiveState.currentTransformsIndex[0] = new int[2];
        setLiveState.currentTransformsIndex[0][0] = 0;
        setLiveState.currentTransformsIndex[0][1] = 0;
        setLiveState.localToVworld = setLiveState.currentTransforms;
        setLiveState.localToVworldIndex = setLiveState.currentTransformsIndex;
        setLiveState.branchGroupPaths = new ArrayList();
        setLiveState.branchGroupPaths.add(new BranchGroupRetained[0]);
        setLiveState.orderedPaths = new ArrayList(1);
        setLiveState.orderedPaths.add(new OrderedPath());
        setLiveState.switchStates = new ArrayList(1);
        setLiveState.switchStates.add(new SwitchState(false));
        branchGroupRetained.setLive(setLiveState);
        J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
        j3dMessage.threads = 4224;
        j3dMessage.type = 32;
        j3dMessage.universe = this.universe;
        j3dMessage.args[0] = setLiveState.ogList.toArray();
        j3dMessage.args[1] = setLiveState.ogChildIdList.toArray();
        j3dMessage.args[2] = setLiveState.ogOrderedIdList.toArray();
        j3dMessage.args[3] = setLiveState.ogCIOList.toArray();
        j3dMessage.args[4] = setLiveState.ogCIOTableList.toArray();
        VirtualUniverse.mc.processMessage(j3dMessage);
        j3dMessage = VirtualUniverse.mc.getMessage();
        j3dMessage.threads = 4096;
        j3dMessage.type = 57;
        j3dMessage.universe = this.universe;
        j3dMessage.args[0] = setLiveState.changedViewGroup;
        j3dMessage.args[1] = setLiveState.changedViewList;
        j3dMessage.args[2] = setLiveState.keyList;
        VirtualUniverse.mc.processMessage(j3dMessage);
        j3dMessage = VirtualUniverse.mc.getMessage();
        j3dMessage.threads = setLiveState.notifyThreads;
        j3dMessage.type = 0;
        j3dMessage.universe = this.universe;
        j3dMessage.args[0] = setLiveState.nodeList.toArray();
        j3dMessage.args[1] = null;
        j3dMessage.args[2] = null;
        if (setLiveState.viewScopedNodeList != null) {
            j3dMessage.args[3] = setLiveState.viewScopedNodeList;
            j3dMessage.args[4] = setLiveState.scopedNodesViewList;
        }
        VirtualUniverse.mc.processMessage(j3dMessage);
        int n = setLiveState.behaviorNodes.size();
        int n2 = 0;
        while (n2 < n) {
            BehaviorRetained behaviorRetained = (BehaviorRetained)setLiveState.behaviorNodes.get(n2);
            behaviorRetained.executeInitialize();
            ++n2;
        }
        j3dMessage = VirtualUniverse.mc.getMessage();
        j3dMessage.threads = 256;
        j3dMessage.type = 49;
        j3dMessage.universe = this.universe;
        VirtualUniverse.mc.processMessage(j3dMessage);
        setLiveState.reset(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBranchGraph(BranchGroup branchGroup) {
        if (this.universe == null) {
            throw new IllegalStateException(J3dI18N.getString("Locale4"));
        }
        if (!branchGroup.getCapability(17)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Locale1"));
        }
        this.universe.resetWaitMCFlag();
        Object object = this.universe.sceneGraphLock;
        synchronized (object) {
            this.doRemoveBranchGraph(branchGroup, null, 0);
            this.universe.setLiveState.reset(this);
        }
        this.universe.waitForMC();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeFromUniverse() {
        if (this.branchGroups.size() > 0) {
            this.universe.resetWaitMCFlag();
            Object object = this.universe.sceneGraphLock;
            synchronized (object) {
                Object[] objectArray = this.branchGroups.toArray();
                int n = 0;
                while (n < objectArray.length) {
                    this.doRemoveBranchGraph((BranchGroup)objectArray[n], null, 0);
                    ++n;
                }
            }
            this.universe.waitForMC();
        }
        if (this.nodeId != null) {
            this.universe.nodeIdFreeList.addElement(this.nodeId);
            this.nodeId = null;
        }
        this.universe = null;
    }

    void doRemoveBranchGraph(BranchGroup branchGroup, J3dMessage[] j3dMessageArray, int n) {
        BranchGroupRetained branchGroupRetained = (BranchGroupRetained)branchGroup.retained;
        if (!branchGroup.isLive()) {
            return;
        }
        branchGroupRetained.attachedToLocale = false;
        this.branchGroups.removeElement(branchGroup);
        this.universe.setLiveState.reset(this);
        branchGroupRetained.clearLive(this.universe.setLiveState);
        branchGroupRetained.setParent(null);
        branchGroupRetained.setLocale(null);
        J3dMessage j3dMessage = j3dMessageArray == null ? VirtualUniverse.mc.getMessage() : j3dMessageArray[n++];
        j3dMessage.threads = 4224;
        j3dMessage.type = 33;
        j3dMessage.universe = this.universe;
        j3dMessage.args[0] = this.universe.setLiveState.ogList.toArray();
        j3dMessage.args[1] = this.universe.setLiveState.ogChildIdList.toArray();
        j3dMessage.args[3] = this.universe.setLiveState.ogCIOList.toArray();
        j3dMessage.args[4] = this.universe.setLiveState.ogCIOTableList.toArray();
        if (j3dMessageArray == null) {
            VirtualUniverse.mc.processMessage(j3dMessage);
            j3dMessage = VirtualUniverse.mc.getMessage();
        } else {
            j3dMessage = j3dMessageArray[n++];
        }
        j3dMessage.threads = 4096;
        j3dMessage.type = 58;
        j3dMessage.universe = this.universe;
        j3dMessage.args[0] = this.universe.setLiveState.changedViewGroup;
        j3dMessage.args[1] = this.universe.setLiveState.keyList;
        if (j3dMessageArray == null) {
            VirtualUniverse.mc.processMessage(j3dMessage);
            j3dMessage = VirtualUniverse.mc.getMessage();
        } else {
            j3dMessage = j3dMessageArray[n++];
        }
        j3dMessage.threads = this.universe.setLiveState.notifyThreads;
        j3dMessage.type = 1;
        j3dMessage.universe = this.universe;
        j3dMessage.args[0] = this.universe.setLiveState.nodeList.toArray();
        if (this.universe.setLiveState.viewScopedNodeList != null) {
            j3dMessage.args[3] = this.universe.setLiveState.viewScopedNodeList;
            j3dMessage.args[4] = this.universe.setLiveState.scopedNodesViewList;
        }
        if (j3dMessageArray == null) {
            VirtualUniverse.mc.processMessage(j3dMessage);
        } else {
            j3dMessage = j3dMessageArray[n++];
        }
        if (this.universe.isEmpty()) {
            VirtualUniverse.mc.postRequest(MasterControl.EMPTY_UNIVERSE, this.universe);
        }
        this.universe.setLiveState.reset(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceBranchGraph(BranchGroup branchGroup, BranchGroup branchGroup2) {
        if (this.universe == null) {
            throw new IllegalStateException(J3dI18N.getString("Locale4"));
        }
        if (!branchGroup.getCapability(17)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Locale1"));
        }
        if (((BranchGroupRetained)branchGroup2.retained).parent != null) {
            throw new MultipleParentException(J3dI18N.getString("Locale3"));
        }
        this.universe.resetWaitMCFlag();
        Object object = this.universe.sceneGraphLock;
        synchronized (object) {
            this.doReplaceBranchGraph(branchGroup, branchGroup2);
            this.universe.setLiveState.reset(this);
        }
        this.universe.waitForMC();
    }

    void doReplaceBranchGraph(BranchGroup branchGroup, BranchGroup branchGroup2) {
        BranchGroupRetained branchGroupRetained = (BranchGroupRetained)branchGroup.retained;
        BranchGroupRetained branchGroupRetained2 = (BranchGroupRetained)branchGroup2.retained;
        this.branchGroups.removeElement(branchGroup);
        branchGroupRetained.attachedToLocale = false;
        this.universe.setLiveState.reset(this);
        branchGroupRetained.clearLive(this.universe.setLiveState);
        J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
        j3dMessage.threads = 4224;
        j3dMessage.type = 33;
        j3dMessage.universe = this.universe;
        j3dMessage.args[0] = this.universe.setLiveState.ogList.toArray();
        j3dMessage.args[1] = this.universe.setLiveState.ogChildIdList.toArray();
        j3dMessage.args[3] = this.universe.setLiveState.ogCIOList.toArray();
        j3dMessage.args[4] = this.universe.setLiveState.ogCIOTableList.toArray();
        VirtualUniverse.mc.processMessage(j3dMessage);
        j3dMessage = VirtualUniverse.mc.getMessage();
        j3dMessage.threads = 4096;
        j3dMessage.type = 58;
        j3dMessage.universe = this.universe;
        j3dMessage.args[0] = this.universe.setLiveState.changedViewGroup;
        j3dMessage.args[1] = this.universe.setLiveState.keyList;
        VirtualUniverse.mc.processMessage(j3dMessage);
        j3dMessage = VirtualUniverse.mc.getMessage();
        j3dMessage.threads = this.universe.setLiveState.notifyThreads;
        j3dMessage.type = 1;
        j3dMessage.universe = this.universe;
        j3dMessage.args[0] = this.universe.setLiveState.nodeList.toArray();
        VirtualUniverse.mc.processMessage(j3dMessage);
        this.branchGroups.addElement(branchGroup2);
        branchGroupRetained2.attachedToLocale = true;
        this.universe.setLiveState.reset(this);
        this.universe.setLiveState.currentTransforms[0] = new Transform3D[2];
        this.universe.setLiveState.currentTransforms[0][0] = new Transform3D();
        this.universe.setLiveState.currentTransforms[0][1] = new Transform3D();
        this.universe.setLiveState.currentTransformsIndex[0] = new int[2];
        this.universe.setLiveState.currentTransformsIndex[0][0] = 0;
        this.universe.setLiveState.currentTransformsIndex[0][1] = 0;
        this.universe.setLiveState.localToVworld = this.universe.setLiveState.currentTransforms;
        this.universe.setLiveState.localToVworldIndex = this.universe.setLiveState.currentTransformsIndex;
        this.universe.setLiveState.branchGroupPaths = new ArrayList();
        this.universe.setLiveState.branchGroupPaths.add(new BranchGroupRetained[0]);
        this.universe.setLiveState.orderedPaths = new ArrayList(1);
        this.universe.setLiveState.orderedPaths.add(new OrderedPath());
        this.universe.setLiveState.switchStates = new ArrayList(1);
        this.universe.setLiveState.switchStates.add(new SwitchState(false));
        branchGroupRetained2.setLive(this.universe.setLiveState);
        J3dMessage j3dMessage2 = VirtualUniverse.mc.getMessage();
        j3dMessage2.threads = 4224;
        j3dMessage2.type = 32;
        j3dMessage2.universe = this.universe;
        j3dMessage2.args[0] = this.universe.setLiveState.ogList.toArray();
        j3dMessage2.args[1] = this.universe.setLiveState.ogChildIdList.toArray();
        j3dMessage2.args[2] = this.universe.setLiveState.ogOrderedIdList.toArray();
        j3dMessage2.args[3] = this.universe.setLiveState.ogCIOList.toArray();
        j3dMessage2.args[4] = this.universe.setLiveState.ogCIOTableList.toArray();
        VirtualUniverse.mc.processMessage(j3dMessage2);
        j3dMessage2 = VirtualUniverse.mc.getMessage();
        j3dMessage2.threads = this.universe.setLiveState.notifyThreads;
        j3dMessage2.type = 0;
        j3dMessage2.universe = this.universe;
        j3dMessage2.args[0] = this.universe.setLiveState.nodeList.toArray();
        j3dMessage2.args[1] = null;
        j3dMessage2.args[2] = null;
        if (this.universe.setLiveState.viewScopedNodeList != null) {
            j3dMessage2.args[3] = this.universe.setLiveState.viewScopedNodeList;
            j3dMessage2.args[4] = this.universe.setLiveState.scopedNodesViewList;
        }
        VirtualUniverse.mc.processMessage(j3dMessage2);
        Object[] objectArray = this.universe.setLiveState.behaviorNodes.toArray();
        if (this.universe.isEmpty()) {
            VirtualUniverse.mc.postRequest(MasterControl.EMPTY_UNIVERSE, this.universe);
        }
        int n = 0;
        while (n < objectArray.length) {
            ((BehaviorRetained)objectArray[n]).executeInitialize();
            ++n;
        }
        j3dMessage2 = VirtualUniverse.mc.getMessage();
        j3dMessage2.threads = 256;
        j3dMessage2.type = 49;
        j3dMessage2.universe = this.universe;
        VirtualUniverse.mc.processMessage(j3dMessage2);
        this.universe.setLiveState.reset(null);
    }

    public int numBranchGraphs() {
        return this.branchGroups.size();
    }

    public Enumeration getAllBranchGraphs() {
        if (this.universe == null) {
            throw new IllegalStateException(J3dI18N.getString("Locale4"));
        }
        return this.branchGroups.elements();
    }

    public SceneGraphPath[] pickAll(PickShape pickShape) {
        if (this.universe == null) {
            throw new IllegalStateException(J3dI18N.getString("Locale4"));
        }
        return Picking.pickAll(this, pickShape);
    }

    public SceneGraphPath[] pickAllSorted(PickShape pickShape) {
        if (this.universe == null) {
            throw new IllegalStateException(J3dI18N.getString("Locale4"));
        }
        return Picking.pickAllSorted(this, pickShape);
    }

    public SceneGraphPath pickClosest(PickShape pickShape) {
        if (this.universe == null) {
            throw new IllegalStateException(J3dI18N.getString("Locale4"));
        }
        return Picking.pickClosest(this, pickShape);
    }

    public SceneGraphPath pickAny(PickShape pickShape) {
        if (this.universe == null) {
            throw new IllegalStateException(J3dI18N.getString("Locale4"));
        }
        return Picking.pickAny(this, pickShape);
    }

    protected void finalize() {
        if (this.universe != null && this.nodeId != null) {
            this.universe.nodeIdFreeList.addElement(this.nodeId);
            this.nodeId = null;
        }
    }
}

