/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import java.util.Arrays;
import javax.media.j3d.GeometryArrayRetained;
import javax.media.j3d.GeometryRetained;
import javax.media.j3d.IndexedGeometryArrayRetained;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.J3dStructure;
import javax.media.j3d.MorphRetained;
import javax.media.j3d.NodeComponentRetained;
import javax.media.j3d.ObjectUpdate;
import javax.media.j3d.SceneGraphObjectRetained;
import javax.media.j3d.TextureAttributesRetained;
import javax.media.j3d.VirtualUniverse;

class RenderingAttributesStructure
extends J3dStructure
implements ObjectUpdate {
    ArrayList objList = new ArrayList();

    RenderingAttributesStructure() {
        super(null, 1024);
    }

    void processMessages(long l) {
        boolean bl = false;
        Object[] objectArray = this.getMessages(l);
        int n = this.getNumMessage();
        if (n <= 0) {
            return;
        }
        int n2 = 0;
        while (n2 < n) {
            J3dMessage j3dMessage = objectArray[n2];
            switch (j3dMessage.type) {
                case 18: 
                case 47: {
                    int n3 = (Integer)j3dMessage.args[1];
                    NodeComponentRetained nodeComponentRetained = (NodeComponentRetained)j3dMessage.args[0];
                    nodeComponentRetained.mirror.changedFrequent = (Integer)j3dMessage.args[3];
                    this.updateNodeComponent(j3dMessage.args);
                    if (nodeComponentRetained.mirror.changedFrequent != 0) {
                        this.objList.add(j3dMessage);
                        bl = true;
                        nodeComponentRetained.mirror.compChanged |= n3;
                        break;
                    }
                    j3dMessage.decRefcount();
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 12: 
                case 13: 
                case 14: {
                    NodeComponentRetained nodeComponentRetained = (NodeComponentRetained)j3dMessage.args[0];
                    nodeComponentRetained.mirror.changedFrequent = (Integer)j3dMessage.args[3];
                    if (nodeComponentRetained.mirror.changedFrequent != 0) {
                        this.objList.add(j3dMessage);
                        bl = true;
                        nodeComponentRetained.mirror.compChanged = 1;
                        break;
                    }
                    this.updateNodeComponent(j3dMessage.args);
                    j3dMessage.decRefcount();
                    break;
                }
                case 54: {
                    NodeComponentRetained nodeComponentRetained = (NodeComponentRetained)j3dMessage.args[0];
                    int n4 = (Integer)j3dMessage.args[3];
                    if (nodeComponentRetained.mirror != null) {
                        nodeComponentRetained.mirror.changedFrequent = n4;
                    }
                    if (n4 != 0) {
                        this.objList.add(j3dMessage);
                        bl = true;
                        break;
                    }
                    this.updateNodeComponent(j3dMessage.args);
                    j3dMessage.decRefcount();
                    break;
                }
                case 11: {
                    NodeComponentRetained nodeComponentRetained = (NodeComponentRetained)j3dMessage.args[0];
                    nodeComponentRetained.mirror.changedFrequent = (Integer)j3dMessage.args[4];
                    if (nodeComponentRetained.mirror.changedFrequent != 0) {
                        this.objList.add(j3dMessage);
                        bl = true;
                        nodeComponentRetained.mirror.compChanged = 1;
                        break;
                    }
                    this.updateTextureAttributes(j3dMessage.args);
                    j3dMessage.decRefcount();
                    break;
                }
                case 15: {
                    NodeComponentRetained nodeComponentRetained = (NodeComponentRetained)j3dMessage.args[0];
                    int n5 = (Integer)j3dMessage.args[1];
                    nodeComponentRetained.mirror.changedFrequent = (Integer)j3dMessage.args[3];
                    this.objList.add(j3dMessage);
                    nodeComponentRetained.mirror.compChanged = 1;
                    bl = true;
                    break;
                }
                case 17: {
                    int n6;
                    GeometryRetained geometryRetained = (GeometryRetained)j3dMessage.args[1];
                    if (geometryRetained instanceof IndexedGeometryArrayRetained) {
                        int n7;
                        this.objList.add(j3dMessage);
                        bl = true;
                        if (j3dMessage.args[2] != null) break;
                        geometryRetained.cachedChangedFrequent = n7 = ((Integer)j3dMessage.args[3]).intValue();
                        break;
                    }
                    geometryRetained.cachedChangedFrequent = n6 = ((Integer)j3dMessage.args[3]).intValue();
                    j3dMessage.decRefcount();
                    break;
                }
                case 16: {
                    this.objList.add(j3dMessage);
                    bl = true;
                    break;
                }
                default: {
                    j3dMessage.decRefcount();
                }
            }
            ++n2;
        }
        if (bl) {
            VirtualUniverse.mc.addMirrorObject(this);
        }
        Arrays.fill(objectArray, 0, n, null);
    }

    public void updateObject() {
        int n = this.objList.size();
        int n2 = 0;
        while (n2 < n) {
            SceneGraphObjectRetained sceneGraphObjectRetained;
            J3dMessage j3dMessage = (J3dMessage)this.objList.get(n2);
            if (j3dMessage.type == 17) {
                sceneGraphObjectRetained = (GeometryArrayRetained)j3dMessage.args[1];
                if (j3dMessage.args[2] == null) {
                    ((GeometryArrayRetained)sceneGraphObjectRetained).updateMirrorGeometry();
                } else {
                    ((GeometryArrayRetained)sceneGraphObjectRetained).initMirrorGeometry();
                }
            } else if (j3dMessage.type == 16) {
                sceneGraphObjectRetained = (MorphRetained)j3dMessage.args[0];
                GeometryArrayRetained geometryArrayRetained = (GeometryArrayRetained)((MorphRetained)sceneGraphObjectRetained).morphedGeometryArray.retained;
                geometryArrayRetained.updateMirrorGeometry();
            } else if (j3dMessage.type == 11) {
                sceneGraphObjectRetained = (NodeComponentRetained)j3dMessage.args[0];
                ((NodeComponentRetained)sceneGraphObjectRetained).mirror.compChanged = 0;
                this.updateTextureAttributes(j3dMessage.args);
            } else if (j3dMessage.type == 18 || j3dMessage.type == 47) {
                sceneGraphObjectRetained = (NodeComponentRetained)j3dMessage.args[0];
                ((NodeComponentRetained)sceneGraphObjectRetained).mirror.compChanged = 0;
            } else {
                sceneGraphObjectRetained = (NodeComponentRetained)j3dMessage.args[0];
                if (((NodeComponentRetained)sceneGraphObjectRetained).mirror != null) {
                    ((NodeComponentRetained)sceneGraphObjectRetained).mirror.compChanged = 0;
                }
                this.updateNodeComponent(j3dMessage.args);
            }
            j3dMessage.decRefcount();
            ++n2;
        }
        this.objList.clear();
    }

    void updateNodeComponent(Object[] objectArray) {
        NodeComponentRetained nodeComponentRetained = (NodeComponentRetained)objectArray[0];
        nodeComponentRetained.updateMirrorObject((Integer)objectArray[1], objectArray[2]);
    }

    void updateTextureAttributes(Object[] objectArray) {
        TextureAttributesRetained textureAttributesRetained = (TextureAttributesRetained)objectArray[0];
        textureAttributesRetained.updateMirrorObject((Integer)objectArray[1], objectArray[2], objectArray[3]);
    }

    void removeNodes(J3dMessage j3dMessage) {
    }

    void cleanup() {
    }
}

