/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.samples;

import edu.uci.ics.jung.algorithms.layout.FRLayout;
import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.util.TestGraphs;
import edu.uci.ics.jung.visualization.DefaultVisualizationModel;
import edu.uci.ics.jung.visualization.GraphZoomScrollPane;
import edu.uci.ics.jung.visualization.VisualizationModel;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.CrossoverScalingControl;
import edu.uci.ics.jung.visualization.control.DefaultModalGraphMouse;
import edu.uci.ics.jung.visualization.control.ScalingControl;
import edu.uci.ics.jung.visualization.decorators.PickableEdgePaintTransformer;
import edu.uci.ics.jung.visualization.decorators.PickableVertexPaintTransformer;
import edu.uci.ics.jung.visualization.decorators.ToStringLabeller;
import edu.uci.ics.jung.visualization.picking.PickedInfo;
import edu.uci.ics.jung.visualization.picking.PickedState;
import edu.uci.ics.jung.visualization.renderers.Renderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import org.apache.commons.collections15.Transformer;

public class VertexLabelPositionDemo
extends JApplet {
    Graph<String, Number> graph = TestGraphs.getOneComponentGraph();
    Layout<String, Number> graphLayout = new FRLayout(this.graph);
    VisualizationViewer<String, Number> vv;
    ScalingControl scaler;

    public VertexLabelPositionDemo() {
        ((FRLayout)this.graphLayout).setMaxIterations(1000);
        Dimension preferredSize = new Dimension(600, 600);
        DefaultVisualizationModel visualizationModel = new DefaultVisualizationModel(this.graphLayout, preferredSize);
        this.vv = new VisualizationViewer((VisualizationModel)visualizationModel, preferredSize);
        PickedState ps = this.vv.getPickedVertexState();
        PickedState pes = this.vv.getPickedEdgeState();
        this.vv.getRenderContext().setVertexFillPaintTransformer((Transformer)new PickableVertexPaintTransformer((PickedInfo)ps, (Paint)Color.red, (Paint)Color.yellow));
        this.vv.getRenderContext().setEdgeDrawPaintTransformer((Transformer)new PickableEdgePaintTransformer((PickedInfo)pes, (Paint)Color.black, (Paint)Color.cyan));
        this.vv.setBackground(Color.white);
        this.vv.getRenderer().getVertexLabelRenderer().setPosition(Renderer.VertexLabel.Position.W);
        this.vv.getRenderContext().setVertexLabelTransformer((Transformer)new ToStringLabeller());
        this.vv.setVertexToolTipTransformer((Transformer)new ToStringLabeller());
        Container content = this.getContentPane();
        GraphZoomScrollPane gzsp = new GraphZoomScrollPane(this.vv);
        content.add((Component)gzsp);
        DefaultModalGraphMouse graphMouse = new DefaultModalGraphMouse();
        this.vv.setGraphMouse((VisualizationViewer.GraphMouse)graphMouse);
        this.vv.addKeyListener(graphMouse.getModeKeyListener());
        CrossoverScalingControl scaler = new CrossoverScalingControl();
        JButton plus = new JButton("+");
        plus.addActionListener(new ActionListener((ScalingControl)scaler){
            final /* synthetic */ ScalingControl val$scaler;
            {
                this.val$scaler = scalingControl;
            }

            public void actionPerformed(ActionEvent e) {
                this.val$scaler.scale(VertexLabelPositionDemo.this.vv, 1.1f, VertexLabelPositionDemo.this.vv.getCenter());
            }
        });
        JButton minus = new JButton("-");
        minus.addActionListener(new ActionListener((ScalingControl)scaler){
            final /* synthetic */ ScalingControl val$scaler;
            {
                this.val$scaler = scalingControl;
            }

            public void actionPerformed(ActionEvent e) {
                this.val$scaler.scale(VertexLabelPositionDemo.this.vv, 0.9090909f, VertexLabelPositionDemo.this.vv.getCenter());
            }
        });
        JPanel positionPanel = new JPanel();
        positionPanel.setBorder(BorderFactory.createTitledBorder("Label Position"));
        JMenuBar menubar = new JMenuBar();
        menubar.add(graphMouse.getModeMenu());
        gzsp.setCorner((JComponent)menubar);
        JComboBox<Renderer.VertexLabel.Position> cb = new JComboBox<Renderer.VertexLabel.Position>();
        cb.addItem(Renderer.VertexLabel.Position.N);
        cb.addItem(Renderer.VertexLabel.Position.NE);
        cb.addItem(Renderer.VertexLabel.Position.E);
        cb.addItem(Renderer.VertexLabel.Position.SE);
        cb.addItem(Renderer.VertexLabel.Position.S);
        cb.addItem(Renderer.VertexLabel.Position.SW);
        cb.addItem(Renderer.VertexLabel.Position.W);
        cb.addItem(Renderer.VertexLabel.Position.NW);
        cb.addItem(Renderer.VertexLabel.Position.N);
        cb.addItem(Renderer.VertexLabel.Position.CNTR);
        cb.addItem(Renderer.VertexLabel.Position.AUTO);
        cb.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                Renderer.VertexLabel.Position position = (Renderer.VertexLabel.Position)e.getItem();
                VertexLabelPositionDemo.this.vv.getRenderer().getVertexLabelRenderer().setPosition(position);
                VertexLabelPositionDemo.this.vv.repaint();
            }
        });
        cb.setSelectedItem(Renderer.VertexLabel.Position.SE);
        positionPanel.add(cb);
        JPanel controls = new JPanel();
        JPanel zoomControls = new JPanel(new GridLayout(2, 1));
        zoomControls.setBorder(BorderFactory.createTitledBorder("Zoom"));
        zoomControls.add(plus);
        zoomControls.add(minus);
        controls.add(zoomControls);
        controls.add(positionPanel);
        content.add((Component)controls, "South");
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        f.setDefaultCloseOperation(3);
        f.getContentPane().add(new VertexLabelPositionDemo());
        f.pack();
        f.setVisible(true);
    }
}

