/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.samples;

import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.algorithms.layout.PolarPoint;
import edu.uci.ics.jung.algorithms.layout.RadialTreeLayout;
import edu.uci.ics.jung.algorithms.layout.TreeLayout;
import edu.uci.ics.jung.algorithms.util.IterativeContext;
import edu.uci.ics.jung.graph.DelegateForest;
import edu.uci.ics.jung.graph.DelegateTree;
import edu.uci.ics.jung.graph.DirectedGraph;
import edu.uci.ics.jung.graph.DirectedSparseMultigraph;
import edu.uci.ics.jung.graph.Forest;
import edu.uci.ics.jung.graph.Tree;
import edu.uci.ics.jung.visualization.GraphZoomScrollPane;
import edu.uci.ics.jung.visualization.Layer;
import edu.uci.ics.jung.visualization.VisualizationServer;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.CrossoverScalingControl;
import edu.uci.ics.jung.visualization.control.DefaultModalGraphMouse;
import edu.uci.ics.jung.visualization.control.ModalGraphMouse;
import edu.uci.ics.jung.visualization.control.ScalingControl;
import edu.uci.ics.jung.visualization.decorators.EdgeShape;
import edu.uci.ics.jung.visualization.decorators.ToStringLabeller;
import edu.uci.ics.jung.visualization.layout.LayoutTransition;
import edu.uci.ics.jung.visualization.util.Animator;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import org.apache.commons.collections15.Factory;
import org.apache.commons.collections15.Transformer;
import org.apache.commons.collections15.functors.ConstantTransformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class L2RTreeLayoutDemo
extends JApplet {
    Forest<String, Integer> graph;
    Factory<DirectedGraph<String, Integer>> graphFactory = new Factory<DirectedGraph<String, Integer>>(){

        @Override
        public DirectedGraph<String, Integer> create() {
            return new DirectedSparseMultigraph();
        }
    };
    Factory<Tree<String, Integer>> treeFactory = new Factory<Tree<String, Integer>>(){

        @Override
        public Tree<String, Integer> create() {
            return new DelegateTree(L2RTreeLayoutDemo.this.graphFactory);
        }
    };
    Factory<Integer> edgeFactory = new Factory<Integer>(){
        int i = 0;

        @Override
        public Integer create() {
            return this.i++;
        }
    };
    Factory<String> vertexFactory = new Factory<String>(){
        int i = 0;

        @Override
        public String create() {
            return "V" + this.i++;
        }
    };
    VisualizationViewer<String, Integer> vv;
    VisualizationServer.Paintable rings;
    String root;
    TreeLayout<String, Integer> treeLayout;
    RadialTreeLayout<String, Integer> radialLayout;

    public L2RTreeLayoutDemo() {
        this.graph = new DelegateForest();
        this.createTree();
        this.treeLayout = new TreeLayout(this.graph);
        this.radialLayout = new RadialTreeLayout(this.graph);
        this.radialLayout.setSize(new Dimension(600, 600));
        this.vv = new VisualizationViewer(this.treeLayout, new Dimension(600, 600));
        this.vv.setBackground(Color.white);
        this.vv.getRenderContext().setEdgeShapeTransformer((Transformer)new EdgeShape.Line());
        this.vv.getRenderContext().setVertexLabelTransformer((Transformer)new ToStringLabeller());
        this.vv.setVertexToolTipTransformer((Transformer)new ToStringLabeller());
        this.vv.getRenderContext().setArrowFillPaintTransformer(new ConstantTransformer<Color>(Color.lightGray));
        this.rings = new Rings();
        this.setLtoR(this.vv);
        Container content = this.getContentPane();
        GraphZoomScrollPane panel = new GraphZoomScrollPane(this.vv);
        content.add((Component)panel);
        DefaultModalGraphMouse graphMouse = new DefaultModalGraphMouse();
        this.vv.setGraphMouse((VisualizationViewer.GraphMouse)graphMouse);
        JComboBox modeBox = graphMouse.getModeComboBox();
        modeBox.addItemListener(graphMouse.getModeListener());
        graphMouse.setMode(ModalGraphMouse.Mode.TRANSFORMING);
        CrossoverScalingControl scaler = new CrossoverScalingControl();
        JButton plus = new JButton("+");
        plus.addActionListener(new ActionListener((ScalingControl)scaler){
            final /* synthetic */ ScalingControl val$scaler;
            {
                this.val$scaler = scalingControl;
            }

            public void actionPerformed(ActionEvent e) {
                this.val$scaler.scale(L2RTreeLayoutDemo.this.vv, 1.1f, L2RTreeLayoutDemo.this.vv.getCenter());
            }
        });
        JButton minus = new JButton("-");
        minus.addActionListener(new ActionListener((ScalingControl)scaler){
            final /* synthetic */ ScalingControl val$scaler;
            {
                this.val$scaler = scalingControl;
            }

            public void actionPerformed(ActionEvent e) {
                this.val$scaler.scale(L2RTreeLayoutDemo.this.vv, 0.9090909f, L2RTreeLayoutDemo.this.vv.getCenter());
            }
        });
        JToggleButton radial = new JToggleButton("Radial");
        radial.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    LayoutTransition lt = new LayoutTransition(L2RTreeLayoutDemo.this.vv, L2RTreeLayoutDemo.this.treeLayout, L2RTreeLayoutDemo.this.radialLayout);
                    Animator animator = new Animator((IterativeContext)lt);
                    animator.start();
                    L2RTreeLayoutDemo.this.vv.getRenderContext().getMultiLayerTransformer().setToIdentity();
                    L2RTreeLayoutDemo.this.vv.addPreRenderPaintable(L2RTreeLayoutDemo.this.rings);
                } else {
                    LayoutTransition lt = new LayoutTransition(L2RTreeLayoutDemo.this.vv, L2RTreeLayoutDemo.this.radialLayout, L2RTreeLayoutDemo.this.treeLayout);
                    Animator animator = new Animator((IterativeContext)lt);
                    animator.start();
                    L2RTreeLayoutDemo.this.vv.getRenderContext().getMultiLayerTransformer().setToIdentity();
                    L2RTreeLayoutDemo.this.setLtoR((VisualizationViewer<String, Integer>)L2RTreeLayoutDemo.this.vv);
                    L2RTreeLayoutDemo.this.vv.removePreRenderPaintable(L2RTreeLayoutDemo.this.rings);
                }
                L2RTreeLayoutDemo.this.vv.repaint();
            }
        });
        JPanel scaleGrid = new JPanel(new GridLayout(1, 0));
        scaleGrid.setBorder(BorderFactory.createTitledBorder("Zoom"));
        JPanel controls = new JPanel();
        scaleGrid.add(plus);
        scaleGrid.add(minus);
        controls.add(radial);
        controls.add(scaleGrid);
        controls.add(modeBox);
        content.add((Component)controls, "South");
    }

    private void setLtoR(VisualizationViewer<String, Integer> vv) {
        Layout layout = vv.getModel().getGraphLayout();
        Dimension d = layout.getSize();
        Point2D.Double center = new Point2D.Double(d.width / 2, d.height / 2);
        vv.getRenderContext().getMultiLayerTransformer().getTransformer(Layer.LAYOUT).rotate(-1.5707963267948966, (Point2D)center);
    }

    private void createTree() {
        this.graph.addVertex("V0");
        this.graph.addEdge(this.edgeFactory.create(), "V0", "V1");
        this.graph.addEdge(this.edgeFactory.create(), "V0", "V2");
        this.graph.addEdge(this.edgeFactory.create(), "V1", "V4");
        this.graph.addEdge(this.edgeFactory.create(), "V2", "V3");
        this.graph.addEdge(this.edgeFactory.create(), "V2", "V5");
        this.graph.addEdge(this.edgeFactory.create(), "V4", "V6");
        this.graph.addEdge(this.edgeFactory.create(), "V4", "V7");
        this.graph.addEdge(this.edgeFactory.create(), "V3", "V8");
        this.graph.addEdge(this.edgeFactory.create(), "V6", "V9");
        this.graph.addEdge(this.edgeFactory.create(), "V4", "V10");
        this.graph.addVertex("A0");
        this.graph.addEdge(this.edgeFactory.create(), "A0", "A1");
        this.graph.addEdge(this.edgeFactory.create(), "A0", "A2");
        this.graph.addEdge(this.edgeFactory.create(), "A0", "A3");
        this.graph.addVertex("B0");
        this.graph.addEdge(this.edgeFactory.create(), "B0", "B1");
        this.graph.addEdge(this.edgeFactory.create(), "B0", "B2");
        this.graph.addEdge(this.edgeFactory.create(), "B1", "B4");
        this.graph.addEdge(this.edgeFactory.create(), "B2", "B3");
        this.graph.addEdge(this.edgeFactory.create(), "B2", "B5");
        this.graph.addEdge(this.edgeFactory.create(), "B4", "B6");
        this.graph.addEdge(this.edgeFactory.create(), "B4", "B7");
        this.graph.addEdge(this.edgeFactory.create(), "B3", "B8");
        this.graph.addEdge(this.edgeFactory.create(), "B6", "B9");
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        Container content = frame.getContentPane();
        frame.setDefaultCloseOperation(3);
        content.add(new L2RTreeLayoutDemo());
        frame.pack();
        frame.setVisible(true);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Rings
    implements VisualizationServer.Paintable {
        Collection<Double> depths = this.getDepths();

        private Collection<Double> getDepths() {
            HashSet<Double> depths = new HashSet<Double>();
            Map polarLocations = L2RTreeLayoutDemo.this.radialLayout.getPolarLocations();
            for (String v : L2RTreeLayoutDemo.this.graph.getVertices()) {
                PolarPoint pp = (PolarPoint)polarLocations.get(v);
                depths.add(pp.getRadius());
            }
            return depths;
        }

        public void paint(Graphics g) {
            g.setColor(Color.lightGray);
            Graphics2D g2d = (Graphics2D)g;
            Point2D center = L2RTreeLayoutDemo.this.radialLayout.getCenter();
            Ellipse2D.Double ellipse = new Ellipse2D.Double();
            for (double d : this.depths) {
                ellipse.setFrameFromDiagonal(center.getX() - d, center.getY() - d, center.getX() + d, center.getY() + d);
                Shape shape = L2RTreeLayoutDemo.this.vv.getRenderContext().getMultiLayerTransformer().getTransformer(Layer.LAYOUT).transform((Shape)ellipse);
                g2d.draw(shape);
            }
        }

        public boolean useTransform() {
            return true;
        }
    }
}

