/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.CachedTargets;

class SwitchState {
    long[] compositeSwitchMask = new long[]{0L};
    boolean cachedSwitchOn = true;
    boolean currentSwitchOn = true;
    boolean lastSwitchOn = true;
    boolean initialized = false;
    CachedTargets cachedTargets = null;
    boolean inSwitch = false;

    public SwitchState(boolean bl) {
        this.inSwitch = bl;
        this.initialized = !bl;
    }

    void dump() {
        System.out.println(" MASK " + this.compositeSwitchMask[0] + " CACH " + this.cachedSwitchOn + " CURR " + this.currentSwitchOn + " LAST " + this.lastSwitchOn);
    }

    void updateCompositeSwitchMask(int n, boolean bl) {
        if (n < 64) {
            this.compositeSwitchMask[0] = bl ? this.compositeSwitchMask[0] & (long)(~(1 << n)) : this.compositeSwitchMask[0] | (long)(1 << n);
        } else {
            int n2 = n / 64;
            int n3 = n % 64;
            if (n2 > this.compositeSwitchMask.length) {
                long[] lArray = new long[n2 + 1];
                System.arraycopy(this.compositeSwitchMask, 0, lArray, 0, n2);
                this.compositeSwitchMask = lArray;
            }
            if (bl) {
                int n4 = n2;
                this.compositeSwitchMask[n4] = this.compositeSwitchMask[n4] & (long)(~(1 << n3));
            } else {
                int n5 = n2;
                this.compositeSwitchMask[n5] = this.compositeSwitchMask[n5] | (long)(1 << n3);
            }
        }
    }

    void initSwitchOn() {
        boolean bl;
        this.lastSwitchOn = this.cachedSwitchOn = (bl = this.evalCompositeSwitchOn());
        this.currentSwitchOn = this.cachedSwitchOn;
        this.initialized = true;
    }

    void updateCurrentSwitchOn() {
        this.currentSwitchOn = !this.currentSwitchOn;
    }

    void updateLastSwitchOn() {
        this.lastSwitchOn = this.currentSwitchOn;
    }

    void updateCachedSwitchOn() {
        this.cachedSwitchOn = !this.cachedSwitchOn;
    }

    boolean evalCompositeSwitchOn() {
        boolean bl;
        if (this.compositeSwitchMask.length == 1) {
            bl = this.compositeSwitchMask[0] == 0L;
        } else {
            bl = true;
            int n = 0;
            while (n < this.compositeSwitchMask.length) {
                if (this.compositeSwitchMask[n] != 0L) {
                    bl = false;
                    break;
                }
                ++n;
            }
        }
        return bl;
    }
}

